% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/formatTable.R
\name{formatTable}
\alias{formatTable}
\title{Format a summarised_result object into a gt, flextable or tibble object}
\usage{
formatTable(
  result,
  formatEstimateName,
  header,
  split,
  groupColumn = NULL,
  type = "gt",
  minCellCount = 5,
  excludeColumns = c("result_id", "result_type", "package_name", "package_version",
    "estimate_type"),
  .options = list()
)
}
\arguments{
\item{result}{A summarised_result.}

\item{formatEstimateName}{Named list of estimate name's to join, sorted by
computation order. Indicate estimate_name's between <...>.}

\item{header}{A vector containing which elements should go into the header
in order (\code{cdm_name}, \code{group}, \code{strata}, \code{additional},
\code{variable}, \code{estimate}, and \code{settings}).}

\item{split}{A vector containing the name-level groups to split ("group",
"strata", "additional"), or an empty character vector to not split.}

\item{groupColumn}{Column to use as group labels.}

\item{type}{Type of desired formatted table, possibilities: "gt",
"flextable", "tibble".}

\item{minCellCount}{Counts below which results will be clouded.}

\item{excludeColumns}{Columns to drop from the output table.}

\item{.options}{Named list with additional formatting options.
visOmopResults::optionsFormatTable() shows allowed arguments and
their default values.}
}
\value{
A tibble, gt, or flextable object.
}
\description{
Format a summarised_result object into a gt, flextable or tibble object
}
\examples{
mockSummarisedResult() |> formatTable(
  formatEstimateName = c("N\%" = "<count> (<percentage>)",
                         "N" = "<count>",
                         "Mean (SD)" = "<mean> (<sd>)"),
  header = c("group"),
  split = c("group","strata",  "additional")
)

}
