% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pairwise_count.R
\name{pairwise_count}
\alias{pairwise_count}
\title{Perform a pairwise count of words by id}
\usage{
pairwise_count(data, id = "line", word = "word")
}
\arguments{
\item{data}{Data frame output from \code{tm_clean()}.}

\item{id}{String to represent the id variable. Defaults to \code{"line"}.}

\item{word}{String to represent the word variable. Defaults to \code{"word"}.}
}
\value{
data frame with the following columns representing a pairwise count:
\itemize{
\item \code{"item1"}
\item \code{"item2"}
\item \code{"n"}
}
}
\description{
This is a 'data.table' implementation that mimics the output of
\code{pairwise_count()} from 'widyr' to reduce package dependency. This is used
internally within \code{tm_cooc()}.
}
\examples{
td <- data.frame(line = c(1, 1, 2, 2),
                 word = c("work", "meeting", "catch", "up"))

pairwise_count(td, id = "line", word = "word")

}
\seealso{
Other Support: 
\code{\link{camel_clean}()},
\code{\link{check_inputs}()},
\code{\link{cut_hour}()},
\code{\link{extract_date_range}()},
\code{\link{extract_hr}()},
\code{\link{heat_colours}()},
\code{\link{is_date_format}()},
\code{\link{maxmin}()},
\code{\link{read_preamble}()},
\code{\link{rgb2hex}()},
\code{\link{totals_bind}()},
\code{\link{totals_col}()},
\code{\link{tstamp}()},
\code{\link{us_to_space}()},
\code{\link{wrap}()}

Other Text-mining: 
\code{\link{meeting_tm_report}()},
\code{\link{tm_clean}()},
\code{\link{tm_cooc}()},
\code{\link{tm_freq}()},
\code{\link{tm_wordcloud}()}
}
\concept{Support}
\concept{Text-mining}
