% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_dur.R
\name{get_dur}
\alias{get_dur}
\title{Time duration}
\usage{
get_dur(x)
}
\arguments{
\item{x}{Wave object from `tuneR::readWave`.}
}
\value{
Numeric indicating the time duration in seconds from a WAV file.
}
\description{
Get time duration from WAV file.
}
\examples{
library(voice)

# get path to audio file
path2wav <- list.files(system.file('extdata', package = 'wrassp'),
pattern <- glob2rx('*.wav'), full.names = TRUE)

rw <- tuneR::readWave(path2wav[1])
voice::get_dur(rw)

rwl <- lapply(path2wav, tuneR::readWave)
sapply(rwl, voice::get_dur)
}
