% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/report.R
\name{report_metrics}
\alias{report_metrics}
\title{Create table and plot for metric variables}
\usage{
report_metrics(
  data,
  cols,
  col_group = NULL,
  ...,
  index = TRUE,
  title = TRUE,
  close = TRUE,
  clean = TRUE
)
}
\arguments{
\item{data}{A data frame}

\item{cols}{A tidy column selection,
e.g. a single column (without quotes)
or multiple columns selected by methods such as starts_with().}

\item{col_group}{Optional, a grouping column (without quotes).}

\item{...}{Parameters passed to the plot and tab functions.}

\item{index}{When the cols contain items on a metric scale
(as determined by \link{get_direction}),
an index will be calculated using the 'psych' package.
Set to FALSE to suppress index generation.}

\item{title}{A character providing the heading or TRUE (default) to output a heading.
Classes for tabset pills will be added.}

\item{close}{Whether to close the last tab (default value TRUE) or to keep it open.
Keep it open to add further custom tabs by adding headers on the fifth level
in Markdown (e.g. ##### Method)}

\item{clean}{Prepare data by \link{data_clean}.}
}
\value{
A volker report object
}
\description{
Depending on your column selection, different types of plots and tables are generated.
See \link{plot_metrics} and \link{tab_metrics}.
}
\details{
For item batteries, an index is calculated and reported.
When used in combination with the Markdown-template "html_report",
the different parts of the report are grouped under a tabsheet selector.
}
\examples{
library(volker)
data <- volker::chatgpt

report_metrics(data, sd_age)

}
