% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cluster.R
\name{cluster_plot}
\alias{cluster_plot}
\title{Get plot for clustering result}
\usage{
cluster_plot(
  data,
  cols,
  newcol = NULL,
  k = NULL,
  method = NULL,
  labels = TRUE,
  clean = TRUE,
  ...
)
}
\arguments{
\item{data}{A tibble.}

\item{cols}{A tidy selection of item columns or a single column with cluster values as a factor.
If the column already contains a cluster result from \link{add_clusters}, it is used, and other parameters are ignored.
If no cluster result exists, it is calculated with \link{add_clusters}.}

\item{newcol}{Name of the new cluster column as a character vector.
Set to NULL (default) to automatically build a name
from the common column prefix, prefixed with "cls_".}

\item{k}{Number of clusters to calculate.
Set to NULL to output a scree plot for up to 10 clusters
and automatically choose the number of clusters based on the elbow criterion.
The within-sums of squares for the scree plot are calculated by
\code{stats::\link[stats:kmeans]{kmeans}}.}

\item{method}{The method as character value. Currently, only kmeans is supported.
All items are scaled before performing the cluster analysis using
\code{base::\link[base:scale]{scale}}.}

\item{labels}{If TRUE (default) extracts labels from the attributes, see \link{codebook}.}

\item{clean}{Prepare data by \link{data_clean}.}

\item{...}{Placeholder to allow calling the method with unused parameters from \link{plot_metrics}.}
}
\value{
A ggplot object.
}
\description{
Kmeans clustering is performed using \link{add_clusters}.

\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#experimental}{\figure{lifecycle-experimental.svg}{options: alt='[Experimental]'}}}{\strong{[Experimental]}}
}
\examples{
library(volker)
data <- volker::chatgpt

cluster_plot(data, starts_with("cg_adoption"), k = 2)

}
\keyword{internal}
