% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/wrappers.R
\name{auth_twitter_app}
\alias{auth_twitter_app}
\title{Twitter App API authentication}
\usage{
auth_twitter_app(bearer, verbose = FALSE, ...)
}
\arguments{
\item{bearer}{Character string. Twitter app bearer token.}

\item{verbose}{Logical. Output additional information. Default is \code{FALSE}.}

\item{...}{Additional parameters passed to function. Not used in this method.}
}
\value{
A \code{credential} object containing an access token \code{$auth} and social media type descriptor
\code{$socialmedia} set to \code{"twitter"}. Object has the class names \code{"credential"} and \code{"twitter"}.
}
\description{
If an individual has applied for and been granted Twitter API access they will also have a bearer token
associated with their app. This token allows read-only access to the API but higher rate-limits so it is the most
suited method for this package and data collection.
}
\note{
\pkg{vosonSML} uses the \pkg{rtweet} package for twitter data collection and also gratefully acknowledges the
techniques and code written by its authors reproduced in this package for creating twitter API access tokens.
}
\examples{
\dontrun{
# twitter API access using an app bearer token
auth <- auth_twitter_app("xxxxxxxxxxxx")
}

}
