% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/margin.plot.R
\name{margin.plot}
\alias{margin.plot}
\title{Plot Phenotype of interest Averaged (Marginalized) Across Specified Markers and Phenotypes}
\usage{
margin.plot(cross, focal.phenotype.name, marginal.phen.names = NULL,
  marginal.marker.names = NULL, genotype.plotting.names = c("A", "H", "B"),
  subset = 1:nind(cross), col = rep(rgb(0.5, 0.5, 0.5, 0.5), nind(cross)),
  pch = 19, xlab.override = NA, ylab.override = NA, title.override = NA,
  title.cex = 1.5, circle.alpha = 0.2)
}
\arguments{
\item{cross}{The cross object to be plotted}

\item{focal.phenotype.name}{the phenotype to put on the y-axis}

\item{marginal.phen.names}{a list of phenotypes to average over (put on the x-axis).}

\item{marginal.marker.names}{a list of marker names, whose values will be averaged over (put on the x-axis).}

\item{genotype.plotting.names}{Labels for the genotype groups.  Defaults to \code{c('AA', 'AB', 'BB')}.}

\item{subset}{the subset of individuals to use}

\item{col}{optionally, color of dots, as in base R graphics.  Defaults to gray.}

\item{pch}{optionally, plotting character, as in base R graphics.  Defaults to 19 (disc).}

\item{xlab.override}{optionally, x axis label, as in base R graphics.  Defaults to the name of the marginal marker.}

\item{ylab.override}{optionally, y axis label, as in base R graphics.  Defaults to focal phenotype name.}

\item{title.override}{optionally, plot title, as in base R graphics.  Defaults to 'focal phenotype name by marginal phenotype name'.}

\item{title.cex}{optionally, character expansion for title, as in base R graphics.  Defaults to 1.5.}

\item{circle.alpha}{optionally, alpha (transparency) of discs.  Defaults to 0.2.}
}
\value{
None.  Only makes plot.
}
\description{
\code{margin.plot} should be used to visually investigate the relationship
   between the phenotype of interest and other phenotypes.  \code{margin.plot} can also
   be used to visualize the relationship between the phenotype of interest and genetic
   loci of interest, but \code{predictive.plot} is usually preferrable.
}
\details{


none
}
\examples{
set.seed(27599)
   my.cross <- sim.cross(map = sim.map(), type = 'f2')
   my.cross$pheno$phenotype <- rnorm(n = 100,
                                     mean = my.cross$geno$`1`$data[,5],
                                     sd = my.cross$geno$`2`$data[,5])
   my.cross$pheno$sex <- rbinom(n = 100, size = 1, prob = 0.5)
   my.cross$pheno$cage <- sample(x = 1:5, size = 100, replace = TRUE)

   margin.plot(cross = my.cross,
               focal.phenotype.name = 'phenotype',
               marginal.phen.name = list('sex', 'cage'),
               marginal.marker.name = list('D1M5', 'D2M5'))
}
\author{
Robert Corty \email{rcorty@gmail.com}
}

