% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.scanonevar.R
\name{plot.scanonevar}
\alias{plot.scanonevar}
\title{plot.scanonevar}
\usage{
\method{plot}{scanonevar}(x, y = NULL,
  chrs = unique(x[["result"]][["chr"]]), tests_to_plot = c("mQTL", "vQTL",
  "mvQTL"), plotting.units = if (any(grepl(pattern = "empir.p", x =
  names(x[["result"]])))) {     "empir.p" } else {     "LOD" },
  plot.title = x[["meta"]][["scan.formulae"]][["mean.alt.formula"]][[2]],
  marker.rug = TRUE, ymax = NULL, legend_pos = NULL,
  alpha_pos = c("left", "right", "none"), alpha_chr = 1, alpha_size = 2,
  ...)
}
\arguments{
\item{x}{the \code{scanonevar} object to be plotted}

\item{y}{Optionally, a \code{scanone} object to be plotting for comparison to the \code{scanonevar} object.}

\item{chrs}{Optionally, the subset of the chromosomes to plot}

\item{tests_to_plot}{which one or ones of the three possible tests to plot ('mQTL', 'vQTL', and 'mvQTL')}

\item{plotting.units}{One of 'LOD', 'asymp.p', or 'empir.p', implying whether
LOD scores, asymptotic p-values, or empirical p-values should be plotted.
Defaults to 'LOD'}

\item{plot.title}{the title of the plot}

\item{marker.rug}{Should a marker rug be plotted? Defaults to TRUE.}

\item{ymax}{the top of the y axis}

\item{legend_pos}{the position of the legend}

\item{alpha_pos}{the position of the alpha values (false positive rate)}

\item{alpha_chr}{which chromosome to put the alphas (FPRs) on}

\item{alpha_size}{size of annotations for alpha=0.05 and alpha=0.01 lines}

\item{...}{additional plotting arguments}
}
\value{
Returns the plot.
}
\description{
\code{plot.scanonevar} implements the plot generic for objects of class 'scanonevar'.
Because scanonevar objects can be viewed in terms of LODs or empirical p-values,
this plotting function checks the 'units' attribute to determine which to plot.
}
\details{
If such a strong signal was observed that the empirical p-value underflows R's
   float type, this function produces an error.  The author is open to suggestions on how
   to deal with this situation better.

   These plots look better when both x (the scanonevar object) and y (optional scanone
   for comparison) are in units p values than when they are in LOD units.

none
}
\examples{
set.seed(27599)
test.cross <- qtl::sim.cross(map = qtl::sim.map(len = rep(20, 3), n.mar = 5), n.ind = 50)
test.sov <- scanonevar(cross = test.cross)
plot(x = test.sov)

}
\author{
Robert Corty \email{rcorty@gmail.com}
}
