% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/isotone.R
\name{solveNonDecreasing}
\alias{solveNonDecreasing}
\title{Solve for best non-decreasing fit using isotone regression 
(from the "isotone" package \url{https://CRAN.R-project.org/package=isotone}).}
\usage{
solveNonDecreasing(varName, x, y, w = NULL)
}
\arguments{
\item{varName}{character, name of variable}

\item{x}{numeric, factor, or character input (not empty, no NAs).}

\item{y}{numeric or castable to such (same length as x no NAs), output to match}

\item{w}{numeric positive, same length as x (weights, can be NULL)}
}
\value{
isotonicly adjusted y (non-decreasing)
}
\description{
Return a vector of length y that is a function of x
(differs at must where x differs) obeying the same order
constraints as x.  This vector is picked as close to
y (by square-distance) as possible.
}
\details{
Please see \url{https://github.com/WinVector/vtreat/blob/main/extras/MonotoneCoder.md}.
}
\examples{

if(requireNamespace("isotone", quietly = TRUE)) {
   solveNonDecreasing('v', 1:3, c(1,2,1))
}

}
