% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/image_to_wal.R
\name{closest.color.from.palette}
\alias{closest.color.from.palette}
\title{Find closest color from palette for each RGB color.}
\usage{
closest.color.from.palette(colors_rgb, fixed_palette_rgb)
}
\arguments{
\item{colors_rgb}{n x 3 integer matrix, the truecolor (arbitrary) input RGB colors for which you want to find the most similar colors included in the fixed palette. Range 0..255.}

\item{fixed_palette_rgb}{the fixed palette, an n x 3 matrix of integers, representing the fixed palette colors in RGB values in range 0..255.}
}
\value{
vector of n integers, the index of the closest color into the palette for each of the \code{colors_rgb}.
}
\description{
Find closest color from a palette for given colors. The similarity method used to define 'closest' is deltaE, and the input RGB colors are transformed to LAB space for the computation, assuming they are given in sRGB space.
}
\examples{
    colors_rgb = matrix(c(255, 0, 0, 100, 100, 100, 10, 10, 10, 5, 5, 5),
     ncol = 3, byrow = TRUE);
    fixed_palette_rgb = matrix(c(255, 0, 0, 255, 5, 0, 11, 11, 11, 0, 0, 0,
     255, 255, 255), ncol = 3, byrow = TRUE);
    pal_similar_colors = closest.color.from.palette(colors_rgb,
     fixed_palette_rgb);

}
