% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/isochrone_esri.R
\name{pixel_walktimes}
\alias{pixel_walktimes}
\title{Extract pixel-accurate walking times from walkalytics raw data isochrones}
\usage{
pixel_walktimes(isochrone_esri)
}
\arguments{
\item{isochrone_esri}{a response object from a \link[walkalytics]{isochrone_esri} call to the \code{walkalytics} isochrone API.}
}
\value{
A \code{data.frame} (\code{tibble::tibble}) that contains:
\itemize{
\item \code{walktime} estimated walking times in seconds from the starting point to every pixel.
\item \code{x} x-coordinate of the pixel.
\item \code{y} y-coordinate of the pixel.
}
}
\description{
\code{pixel_walktimes} extracts walking times for every pixel from a response object from a \link[walkalytics]{isochrone_esri} call.
}
\examples{
\donttest{
isochrone_esri(x = 896488, y = 6006502, key = "abcd1234") \%>\% pixel_walktimes()
}

}
