% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/process_bouts_and_gps_epochs_into_walkbouts.R
\name{evaluate_gps_completeness}
\alias{evaluate_gps_completeness}
\title{Evaluate GPS completeness for each walking bout}
\usage{
evaluate_gps_completeness(
  walk_bouts,
  min_gps_obs_within_bout,
  min_gps_coverage_ratio
)
}
\arguments{
\item{walk_bouts}{A data frame containing information about walking bouts, including GPS data.}

\item{min_gps_obs_within_bout}{The minimum number of GPS observations required for a bout to be considered to have complete GPS data.}

\item{min_gps_coverage_ratio}{The minimum ratio of GPS observations with valid data to total GPS observations for a bout to be considered to have complete GPS data.}
}
\value{
A data frame containing information about the GPS completeness and median speed for each bout.
}
\description{
This function evaluates the completeness of GPS data for each walking bout. For each bout, it checks if the number of valid GPS records (with speed, latitude, and longitude data) is greater than a specified threshold, and if the ratio of valid GPS records to total records is greater than a specified minimum. If both of these conditions are met, the function considers the GPS data for the bout to be complete. The function also calculates the median speed for each bout.
}
