# Generated by using Rcpp::compileAttributes() -> do not edit by hand
# Generator token: 10BE3573-1514-4C36-9D1C-5A225CD40393

rwatTinflex <- function(n, kappa, mu, cT, rho) {
    .Call('_watson_rwatTinflex', PACKAGE = 'watson', n, kappa, mu, cT, rho)
}

rwatACG <- function(n, kappa, mu, b = -10) {
    .Call('_watson_rwatACG', PACKAGE = 'watson', n, kappa, mu, b)
}

#' @title Random Sampling from a Mixture of Watson Distributions
#' @description \code{rmwat} generates a random sample from a mixture of multivariate Watson distributions.
#' @param n an integer giving the number of samples to draw.
#' @param weights a numeric vector with non-negative elements giving the mixture probabilities.
#' @param kappa a numeric vector giving the kappa parameters of the mixture components.
#' @param mu a numeric matrix with columns giving the mu parameters of the mixture components.
#' @param method a string indicating whether ACG sampler (\code{method = acg}), Tynflex sampler (\code{method = tinflex}) or automatic selection (\code{method = auto}) of the sampler should be used, default: "acg".  
#' @param b a positive numeric hyper-parameter used in the sampling. If not a positive value is given, optimal choice of b is used, default: -10.
#' @param cT parameter for transformation (numeric vector of length 1), see \code{\link[Tinflex]{Tinflex.setup}}, default: 0.
#' @param rho performance parameter: requested upper bound for ratio of area below hat to area below squeeze (numeric). See \code{\link[Tinflex]{Tinflex.setup}}, default: 1.1.
#' @return  A matrix with rows equal to the generated values.
#' @details The function generates samples from finite mixtures of Watson distributions,
#'          using methods from Sablica, Hornik and Leydold (2022) \url{https://research.wu.ac.at/en/publications/random-sampling-from-the-watson-distribution}.
#' @examples
#'
#' ## simulate from Watson distribution
#' sample1 <- rmwat(n = 20, weights = 1, kappa = 20, mu = matrix(c(1,1,1),nrow = 3))
#'
#' ## simulate from a mixture of Watson distributions
#' sample2 <- rmwat(n = 20, weights = c(0.5,0.5), kappa = c(-200,-200),
#'                             mu = matrix(c(1,1,1,-1,1,1),nrow = 3))
#' @rdname rmwat
#' @references Sablica, Hornik and Leydold (2022). Random Sampling from the Watson Distribution \url{https://research.wu.ac.at/en/publications/random-sampling-from-the-watson-distribution}.
#' @export
rmwat <- function(n, weights, kappa, mu, method = "acg", b = -10, cT = 0, rho = 1.1) {
    .Call('_watson_rmwat', PACKAGE = 'watson', n, weights, kappa, mu, method, b, cT, rho)
}

g <- function(alpha, beta, x, N = 30L) {
    .Call('_watson_g', PACKAGE = 'watson', alpha, beta, x, N)
}

kummerM <- function(alpha, beta, r) {
    .Call('_watson_kummerM', PACKAGE = 'watson', alpha, beta, r)
}

log_hyperg_1F1 <- function(alpha, beta, r, N = 10L) {
    .Call('_watson_log_hyperg_1F1', PACKAGE = 'watson', alpha, beta, r, N)
}

diam_clus1 <- function(data, K, maxiter = 100L) {
    .Call('_watson_diam_clus1', PACKAGE = 'watson', data, K, maxiter)
}

diam_clus2 <- function(data, K, maxiter = 100L) {
    .Call('_watson_diam_clus2', PACKAGE = 'watson', data, K, maxiter)
}

predictC1 <- function(data, kappa_vector, mu_matrix, pi_vector, E_type, K) {
    .Call('_watson_predictC1', PACKAGE = 'watson', data, kappa_vector, mu_matrix, pi_vector, E_type, K)
}

predictC2 <- function(data, kappa_vector, mu_matrix, pi_vector, E_type, K) {
    .Call('_watson_predictC2', PACKAGE = 'watson', data, kappa_vector, mu_matrix, pi_vector, E_type, K)
}

log_like1 <- function(data, kappa_vector, mu_matrix, pi_vector, K, beta, n) {
    .Call('_watson_log_like1', PACKAGE = 'watson', data, kappa_vector, mu_matrix, pi_vector, K, beta, n)
}

log_like2 <- function(data, kappa_vector, mu_matrix, pi_vector, K, beta, n) {
    .Call('_watson_log_like2', PACKAGE = 'watson', data, kappa_vector, mu_matrix, pi_vector, K, beta, n)
}

EM1 <- function(data, K, E_type, M_type, minalpha = 0, convergence = TRUE, maxiter = 100L, N = 30L, reltol = 1e-9, start = NULL, verbose = FALSE) {
    .Call('_watson_EM1', PACKAGE = 'watson', data, K, E_type, M_type, minalpha, convergence, maxiter, N, reltol, start, verbose)
}

EM2 <- function(data, K, E_type, M_type, minalpha = 0, convergence = TRUE, maxiter = 100L, N = 30L, reltol = 1e-9, start = NULL, verbose = FALSE) {
    .Call('_watson_EM2', PACKAGE = 'watson', data, K, E_type, M_type, minalpha, convergence, maxiter, N, reltol, start, verbose)
}

