\name{dwpt.sim}
\alias{dwpt.sim}
\title{Simulate Seasonal Persistent Processes Using the DWPT}
\description{
  A seasonal persistent process may be characterized by a spectral
  density function with an asymptote occuring at a particular frequency
  in \eqn{[0,\frac{1}{2})}{[0,1/2)}.  It's time domain representation
  was first noted in passing by Hosking (1981).  Although an exact
  time-domain approach to simulation is possible, this function utilizes
  the discrete wavelet packet transform (DWPT).
}
\usage{dwpt.sim(N, wf, delta, fG, M=2, adaptive=TRUE, epsilon=0.05)
}
\arguments{
  \item{N}{Length of time series to be generated.}
  \item{wf}{Character string for the wavelet filter.}
  \item{delta}{Long-memory parameter for the seasonal persistent process.}
  \item{fG}{Gegenbauer frequency.}
  \item{M}{Actual length of simulated time series.}
  \item{adaptive}{Logical; if \code{TRUE} the orthonormal basis used in
    the DWPT is adapted to the ideal spectrum, otherwise the orthonormal
    basis is performed to a maximum depth.}
  \item{epsilon}{Threshold for adaptive basis selection.}
}
\value{
  Time series of length \code{N}.
}
\details{
  Two subroutines are used, the first selects an adaptive orthonormal
  basis for the true spectral density function (SDF) while the second
  computes the bandpass variances associated with the chosen orthonormal
  basis and SDF.  Finally, when \eqn{$M>N$}{\code{M} > \code{N}} a
  uniform random variable is generated in order to select a random piece
  of the simulated time series.  For more details see Whitcher (2001).
}
\references{
  Hosking, J. R. M. (1981)
  Fractional Differencing,
  \emph{Biometrika}, \bold{68}, No. 1, 165-176.
  
  Whitcher, B. (2001)
  Simulating Gaussian Stationary Time Series with Unbounded Spectra,
  \emph{Journal of Computational and Graphical Statistics}, \bold{10},
  No. 1, 112-134.
}
\seealso{
  \code{\link{hosking.sim}} for an exact time-domain method and
  \code{\link{wave.filter}} for a list of available wavelet filters.
}
\examples{
## Generate monthly time series with annual oscillation
## library(ts) is required in order to access acf()
x <- dwpt.sim(256, "mb16", .4, 1/12, M=4, epsilon=.001)
par(mfrow=c(2,1))
plot.ts(x)
if(!is.loaded("acf", "ts"))
  library(ts)
acf(x, lag.max=128, ylim=c(-.6,1))
data(acvs.andel8)
lines(acvs.andel8$lag[1:128], acvs.andel8$acf[1:128], col=2)
}
\author{B. Whitcher}
\keyword{ts}
