% Generated by roxygen2 (4.0.1): do not edit by hand
\name{mean.from.cpt}
\alias{mean.from.cpt}
\title{Mean between change-points}
\usage{
\method{mean}{from.cpt}(x, cpt = NULL, ...)
}
\arguments{
\item{x}{a vector}

\item{cpt}{a vector of integers with localisations of change-points}

\item{...}{further arguments passed to \code{mean} method}
}
\value{
a vector of the same length as \code{x}, piecewise constant and equal to the mean between change-points given in \code{cpt}
}
\description{
The function finds the average of the input vector \code{x} between change-points given in \code{cpt}.
}
\examples{
x <- rnorm(100)+c(rep(-1,50),rep(1,50))
cpt <- 50
mean.from.cpt(x,cpt)
w <- wbs(x)
cpt <- changepoints(w)
mean.from.cpt(x,cpt=cpt$cpt.ic$sbic)
}

