% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gecko.R
\name{gecko}
\alias{gecko}
\title{Start gecko driver}
\usage{
gecko(port = 4567L, version = "latest", check = TRUE,
  loglevel = c("info", "fatal", "error", "warn", "config", "debug", "trace"),
  verbose = TRUE, retcommand = FALSE, ...)
}
\arguments{
\item{port}{Port to run on}

\item{version}{what version of geckodriver to run. Default = "latest"
which runs the most recent version. To see other version currently
sourced run binman::list_versions("geckodriver")}

\item{check}{If TRUE check the versions of geckodriver available. If
new versions are available they will be downloaded.}

\item{loglevel}{Set Gecko log level [values: fatal, error,
warn, info, config, debug, trace]}

\item{verbose}{If TRUE, include status messages (if any)}

\item{retcommand}{If TRUE return only the command that would be passed
to \code{\link{spawn_process}}}

\item{...}{pass additional options to the driver}
}
\value{
Returns a list with named elements process, output, error and
    stop. process is the output from calling \code{\link{spawn_process}}
    output, error and stop are functions calling
    \code{\link{process_read}}, \code{\link{process_read}} with "stderr"
    pipe and \code{\link{process_kill}}  respectively  on process.
}
\description{
Start gecko driver
}
\examples{
\dontrun{
gDrv <- gecko()
gDrv$output()
gDrv$stop()
}
}

