% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rpa_control.R
\name{rpa_control_edgeweight}
\alias{rpa_control_edgeweight}
\title{Control weight of new edges. Defined for \code{rpanet}.}
\usage{
rpa_control_edgeweight(distribution = NULL, dparams = NULL, shift = 1)
}
\arguments{
\item{distribution}{Distribution for drawing edge weights. Default is
\code{NULL}. If specified, its first argument must be the number of
observations.}

\item{dparams}{A list of parameters passed on to \code{distribution}. The
names of parameters must be specified.}

\item{shift}{A constant added to the values sampled from \code{distribution}.
Default value is 1.}
}
\value{
A list of class \code{rpacontrol} with components
  \code{distribution}, \code{dparams}, and \code{shift} with meanings as
  explained under 'Arguments'.
}
\description{
Control weight of new edges. Defined for \code{rpanet}.
}
\examples{
# Edge weight follows Gamma(5, 0.2).
control <- rpa_control_edgeweight(
  distribution = rgamma,
  dparams = list(shape = 5, scale = 0.2),
  shift = 0
)

# Constant edge weight
control <- rpa_control_edgeweight(shift = 2)

}
