% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/request_registry.R
\name{request_registry}
\alias{request_registry}
\title{List requests in the request registry}
\usage{
request_registry()
}
\value{
an object of class \code{RequestRegistry}, print method gives the
requests in the registry and the number of times each one has been
performed
}
\description{
List requests in the request registry
}
\examples{
webmockr::enable()
stub_request("get", "https://httpbin.org/get") \%>\%
  to_return(body = "success!", status = 200)

# make the request
z <- crul::HttpClient$new(url = "https://httpbin.org")$get("get")

# check the request registry - the request was made 1 time
request_registry()

# do the request again
z <- crul::HttpClient$new(url = "https://httpbin.org")$get("get")

# check the request registry - now it's been made 2 times, yay!
request_registry()
}
\seealso{
Other request-registry: \code{\link{HashCounter}},
  \code{\link{RequestRegistry}}
}
