% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/metrics.R
\name{metrics}
\alias{metrics}
\title{Image shape metrics}
\usage{
metrics(stimuli, formula = c(0, 1))
}
\arguments{
\item{stimuli}{list of stimuli with tems}

\item{formula}{a vector of two points to measure the distance apart, or a string of the formula for the metric}
}
\value{
named vector of the metric
}
\description{
Get metrics defined by template points.
}
\details{
Reference x and y coordinates by point number like \code{x[0]} or \code{y[188]}. Use any R functions to process the numbers, as well as \code{pow()} (same as \verb{^()}, for consistency with webmorph.org). Remember that 0,0 is the top left for images; e.g., \code{min(y[0], y[1])} gives your the \emph{higher} of the two pupil y-coordinates.
}
\examples{
stimuli <- demo_stim()

metrics(stimuli, c(0, 1)) # eye-spacing

# face width-to-height ratio
fwh <- "abs(max(x[113],x[112],x[114])-min(x[110],x[111],x[109]))/abs(y[90]-min(y[20],y[25]))"
metrics(stimuli, fwh)

}
\seealso{
Other info: 
\code{\link{add_info}()},
\code{\link{compare}()},
\code{\link{get_info}()},
\code{\link{get_point}()},
\code{\link{height}()},
\code{\link{rename_stim}()},
\code{\link{width}()}
}
\concept{info}
