
test_that("ESPN - WBB Play-by-Play", {
  skip_on_cran()
  x <- espn_wbb_game_all(game_id = 401276115)
  x1 <- x[[1]]
  x2 <- x[[2]]
  x3 <- x[[3]]
  
  cols_x1 <- c(
    "id",
    "sequence_number",
    "text",
    "away_score",
    "home_score",
    "scoring_play",
    "score_value",
    "wallclock",
    "shooting_play",
    "type_id",
    "type_text",
    "period_number",
    "period_display_value",
    "clock_display_value",
    "team_id",
    "coordinate_x_raw",
    "coordinate_y_raw",
    "coordinate_x",
    "coordinate_y",
    "play_id",
    "athlete_id_1",
    "athlete_id_2",
    "home_team_id",
    "home_team_mascot",
    "home_team_name",
    "home_team_abbrev",
    "home_team_logo",
    "home_team_logo_dark",
    "home_team_full_name",
    "home_team_color",
    "home_team_alternate_color",
    "home_team_score",
    "home_team_winner",
    "home_team_record",
    "away_team_id",
    "away_team_mascot",
    "away_team_name",
    "away_team_abbrev",
    "away_team_logo",
    "away_team_logo_dark",
    "away_team_full_name",
    "away_team_color",
    "away_team_alternate_color",
    "away_team_score",
    "away_team_winner",
    "away_team_record",
    "game_id",
    "season",
    "season_type",
    "game_date",
    "game_date_time"
  )
  
  cols_x2 <- c(
    "game_id",
    "season",
    "season_type",
    "game_date",
    "game_date_time",
    "team_id",
    "team_uid",
    "team_slug",
    "team_location",
    "team_name",
    "team_abbreviation",
    "team_display_name",
    "team_short_display_name",
    "team_color",
    "team_alternate_color",
    "team_logo",
    "team_home_away",
    "team_score",
    "team_winner",
    "assists",
    "blocks",
    "defensive_rebounds",
    "field_goal_pct",
    "field_goals_made",
    "field_goals_attempted",
    "flagrant_fouls",
    "fouls",
    "free_throw_pct",
    "free_throws_made",
    "free_throws_attempted",
    "largest_lead",
    "offensive_rebounds",
    "steals",
    "team_turnovers",
    "technical_fouls",
    "three_point_field_goal_pct",
    "three_point_field_goals_made",
    "three_point_field_goals_attempted",
    "total_rebounds",
    "total_technical_fouls",
    "total_turnovers",
    "turnovers",
    "opponent_team_id",
    "opponent_team_uid",
    "opponent_team_slug",
    "opponent_team_location",
    "opponent_team_name",
    "opponent_team_abbreviation",
    "opponent_team_display_name",
    "opponent_team_short_display_name",
    "opponent_team_color",
    "opponent_team_alternate_color",
    "opponent_team_logo",
    "opponent_team_score"
  )
  
  cols_x3 <- c(
    "game_id",
    "season",
    "season_type",
    "game_date",
    "game_date_time",
    "athlete_id",
    "athlete_display_name",
    "team_id",
    "team_name",
    "team_location",
    "team_short_display_name",
    "minutes",
    "field_goals_made",
    "field_goals_attempted",
    "three_point_field_goals_made",
    "three_point_field_goals_attempted",
    "free_throws_made",
    "free_throws_attempted",
    "offensive_rebounds",
    "defensive_rebounds",
    "rebounds",
    "assists",
    "steals",
    "blocks",
    "turnovers",
    "fouls",
    "points",
    "starter",
    "ejected",
    "did_not_play",
    "active",
    "athlete_jersey",
    "athlete_short_name",
    "athlete_headshot_href",
    "athlete_position_name",
    "athlete_position_abbreviation",
    "team_display_name",
    "team_uid",
    "team_slug",
    "team_logo",
    "team_abbreviation",
    "team_color",
    "team_alternate_color",
    "home_away",
    "team_winner",
    "team_score",
    "opponent_team_id",
    "opponent_team_name",
    "opponent_team_location",
    "opponent_team_display_name",
    "opponent_team_abbreviation",
    "opponent_team_logo",
    "opponent_team_color",
    "opponent_team_alternate_color",
    "opponent_team_score"
  )
  
  expect_in(sort(colnames(x$Plays)),sort(cols_x1))
  expect_s3_class(x$Plays, "data.frame")
  expect_in(sort(colnames(x$Team)), sort(cols_x2))
  expect_s3_class(x$Team, "data.frame")
  expect_in(sort(colnames(x$Player)), sort(cols_x3))
  expect_s3_class(x$Player, "data.frame")
})
