% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/confidence_intervals.R
\name{predict_quantile}
\alias{predict_quantile}
\title{Estimation of Quantiles for Parametric Lifetime Distributions}
\usage{
predict_quantile(p, loc_sc_params, distribution = c("weibull", "lognormal",
  "loglogistic"))
}
\arguments{
\item{p}{a numeric vector which consists of failure probabilities
regarding the lifetime data.}

\item{loc_sc_params}{a (named) numeric vector of estimated location
and scale parameters for a specified distribution. The order of
elements is important. First entry needs to be the location
parameter \eqn{\mu} and the second element needs to be the scale
parameter \eqn{\sigma}.}

\item{distribution}{supposed distribution of the random variable. The
value can be \code{"weibull"}, \code{"lognormal"} or \code{"loglogistic"}.
Other distributions have not been implemented yet.}
}
\value{
A vector containing the estimated quantiles for a given set of
  failure probabilities and estimated parameters.
}
\description{
This function estimates the quantiles for a given set of estimated
location-scale parameters and specified failure probabilities.
}
\examples{
quants <- predict_quantile(p = c(0.01, 0.1, 0.5), loc_sc_params = c(5, 0.5),
                           distribution = "weibull")
}
