% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/confidence_intervals.R
\encoding{UTF-8}
\name{confint_betabinom}
\alias{confint_betabinom}
\title{Beta Binomial Confidence Bounds for Quantiles and/or Probabilities}
\usage{
confint_betabinom(x, event, loc_sc_params, distribution = c("weibull",
  "lognormal", "loglogistic", "normal", "logistic", "sev", "weibull3",
  "lognormal3", "loglogistic3"), bounds = c("two_sided", "lower",
  "upper"), conf_level = 0.95, direction = c("y", "x"))
}
\arguments{
\item{x}{a numeric vector which consists of lifetime data. \code{x} is used to
specify the range of confidence region(s).}

\item{event}{a vector of binary data (0 or 1) indicating whether unit \emph{i}
is a right censored observation (= 0) or a failure (= 1).}

\item{loc_sc_params}{a (named) numeric vector of estimated location
and scale parameters for a specified distribution. The order of
elements is important. First entry needs to be the location
parameter \eqn{\mu} and the second element needs to be the scale
parameter \eqn{\sigma}. If a three-parametric model is used the third element
is the threshold parameter \eqn{\gamma}.}

\item{distribution}{supposed distribution of the random variable. The
value can be \code{"weibull"}, \code{"lognormal"}, \code{"loglogistic"},
\code{"normal"}, \code{"logistic"}, \code{"sev"} \emph{(smallest extreme value)},
\code{"weibull3"}, \code{"lognormal3"} or \code{"loglogistic3"}.
Other distributions have not been implemented yet.}

\item{bounds}{a character string specifying the interval(s) which has/have to
be computed. Must be one of "two_sided" (default), "lower" or "upper".}

\item{conf_level}{confidence level of the interval. The default value is
\code{conf_level = 0.95}.}

\item{direction}{a character string specifying the direction of the computed
interval(s). Must be either "y" (failure probabilities) or "x" (quantiles).}
}
\value{
A data frame containing the lifetime characteristic, interpolated
  ranks as a function of probabilities, the probabilities which are used to
  compute the ranks and computed values for the specified confidence bound(s).
}
\description{
This non-parametric approach calculates confidence bounds for quantiles and/or
failure probabilities using a procedure that is similar to that used in
calculating median ranks. The location-scale (and threshold) parameters estimated
by rank regression are needed.
}
\examples{
# Example 1: Beta-Binomial Confidence Bounds for two-parameter Weibull:
obs   <- seq(10000, 100000, 10000)
state <- c(0, 1, 1, 0, 0, 0, 1, 0, 1, 0)

df_john <- johnson_method(x = obs, event = state)

mrr <- rank_regression(x = df_john$characteristic,
                       y = df_john$prob,
                       event = df_john$status,
                       distribution = "weibull",
                       conf_level = .95)

conf_betabin <- confint_betabinom(x = df_john$characteristic,
                                  event = df_john$status,
                                  loc_sc_params = mrr$loc_sc_coefficients,
                                  distribution = "weibull",
                                  bounds = "two_sided",
                                  conf_level = 0.95,
                                  direction = "y")

# Example 2: Beta-Binomial Confidence Bounds for three-parameter Weibull:
# Alloy T7987 dataset taken from Meeker and Escobar(1998, p. 131)
cycles   <- c(300, 300, 300, 300, 300, 291, 274, 271, 269, 257, 256, 227, 226,
              224, 213, 211, 205, 203, 197, 196, 190, 189, 188, 187, 184, 180,
              180, 177, 176, 173, 172, 171, 170, 170, 169, 168, 168, 162, 159,
              159, 159, 159, 152, 152, 149, 149, 144, 143, 141, 141, 140, 139,
              139, 136, 135, 133, 131, 129, 123, 121, 121, 118, 117, 117, 114,
              112, 108, 104, 99, 99, 96, 94)
state <- c(rep(0, 5), rep(1, 67))

df_john2 <- johnson_method(x = cycles, event = state)
mrr_weib3 <- rank_regression(x = df_john2$characteristic,
                       y = df_john2$prob,
                       event = df_john2$status,
                       distribution = "weibull3",
                       conf_level = .95)

conf_betabin_weib3 <- confint_betabinom(x = df_john2$characteristic,
                                  event = df_john2$status,
                                  loc_sc_params = mrr_weib3$loc_sc_coefficients,
                                  distribution = "weibull3",
                                  bounds = "two_sided",
                                  conf_level = 0.95,
                                  direction = "y")
}
\references{
Meeker, William Q; Escobar, Luis A., Statistical methods for
  reliability data, New York: Wiley series in probability and statistics, 1998
}
