% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{calculate_ranks}
\alias{calculate_ranks}
\title{Computation of Johnson Ranks}
\usage{
calculate_ranks(f, n_out, n)
}
\arguments{
\item{f}{a numeric vector indicating the number of failed units for a
specific realization of the lifetime characteristic.}

\item{n_out}{a numeric vector indicating the number of failed and censored
units that have a shorter realization of lifetime characteristic as unit
\emph{i}.}

\item{n}{an integer value indicating the sample size.}
}
\value{
A numeric vector containing the computed Johnson ranks.
}
\description{
This function calculates the Johnson ranks which are used to estimate the
failure probabilities in case of (multiple) right censored data.
}
\examples{
  defectives <- c(0, 1, 2, 0, 0, 0, 3, 0, 2, 0)
  n_out <- c(0, 2, 4, 8, 9, 11, 12, 16, 20, 22)
  n <- 23
  johnson_ranks <- calculate_ranks(f = defectives, n_out = n_out, n = n)
}
