% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ml_estimation.R
\encoding{UTF-8}
\name{ml_estimation}
\alias{ml_estimation}
\alias{ml_estimation.wt_reliability_data}
\title{ML Estimation for Parametric Lifetime Distributions}
\usage{
ml_estimation(x, ...)

\method{ml_estimation}{wt_reliability_data}(
  x,
  distribution = c("weibull", "lognormal", "loglogistic", "normal", "logistic", "sev",
    "weibull3", "lognormal3", "loglogistic3"),
  wts = rep(1, nrow(x)),
  conf_level = 0.95,
  ...
)
}
\arguments{
\item{x}{Object of class \code{wt_reliability_data} returned by
\code{\link{reliability_data}}.}

\item{...}{Further arguments passed to or from other methods. Currently not used.}

\item{distribution}{Supposed distribution of the random variable.}

\item{wts}{Optional vector of case weights. The length of \code{wts} must be the
same as the number of observations in \code{x}.}

\item{conf_level}{Confidence level of the interval.}
}
\value{
Returns a list with classes \code{wt_model}, \code{wt_ml_estimation} and
\code{wt_model_estimation} containing the following elements:
\itemize{
  \item \code{coefficients} : A named vector of estimated coefficients
    (parameters of the assumed distribution). \strong{Note}: The parameters
    are given in location-scale-parameterization.
  \item \code{confint} : Confidence intervals for parameters.
  \item \code{varcov} : Estimated variance-covariance matrix for the
    parameters.
  \item \code{shape_scale_coefficients} : Only included if
    \code{distribution} is \code{"weibull"} or \code{"weibull3"}
    (parameterization used in \code{\link[stats:Weibull]{stats::Weibull}}).
  \item \code{shape_scale_confint} : Only included if \code{distribution} is
    \code{"weibull"} or \code{"weibull3"}. Confidence intervals
    for scale \eqn{\eta} and shape \eqn{\beta} (and threshold \eqn{\gamma})
    if \code{distribution} is \code{"weibull3"}.
  \item \code{logL} : The log-likelihood value.
  \item \code{aic} : Akaike Information Criterion.
  \item \code{bic} : Bayesian Information Criterion.
  \item \code{data} : A tibble with class \code{wt_reliability_data} returned from \code{\link{reliability_data}}.
  \item \code{distribution} : Specified distribution.
}
}
\description{
This function estimates the parameters of a two- or three-parametric lifetime
distribution for complete and (multiple) right censored data. The parameters
are determined in the frequently used (log-)location-scale parameterization.

For the Weibull, estimates are additionally transformed such that they are in
line with the parameterization provided by the \emph{stats} package
(see \link[stats]{Weibull}).
}
\details{
\code{ml_estimation} calls \code{\link[SPREDA:lifedata.MLE]{Lifedata.MLE}},
which is implemented in \emph{SPREDA}, to obtain the estimates. Normal
approximation confidence intervals for the parameters are computed as well.
}
\examples{
# Reliability data preparation:
## Data for two-parametric model:
data_2p <- reliability_data(
  shock,
  x = distance,
  status = status
)

## Data for three-parametric model:
data_3p <- reliability_data(
  alloy,
  x = cycles,
  status = status
)

# Example 1 - Fitting a two-parametric weibull distribution:
ml_2p <- ml_estimation(
  data_2p,
  distribution = "weibull"
)

# Example 2 - Fitting a three-parametric lognormal distribution:
ml_3p <- ml_estimation(
  data_3p,
  distribution = "lognormal3",
  conf_level = 0.99
)

}
\references{
Meeker, William Q; Escobar, Luis A., Statistical methods for
  reliability data, New York: Wiley series in probability and statistics, 1998
}
