% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/functions.R
\name{rank_plot}
\alias{rank_plot}
\title{Plot for official (ATP or WTA) rates}
\usage{
rank_plot(x, players, line_width = 1.5, nbreaks = 1)
}
\arguments{
\item{x}{An object of class 'welo', obtained after running the \code{\link{welofit}} function}

\item{players}{A character vector including the players whose rates will be plotted.
The indication of the player has to be: 'Surname N.'. For instance, 'Roger Federer' will be
included in the 'players' vector as 'Federer R.'}

\item{line_width}{\strong{optional} Line width, by default it is 1.5}

\item{nbreaks}{\strong{optional} Number of breaks for y-axis, by default it is 1}
}
\value{
A ggplot2 plot
}
\description{
Plots the official (ATP or WTA) rates.
}
\examples{
db<-tennis_data("2022","ATP") 
db_clean<-clean(db,MNM=5)
res_welo<-welofit(db_clean)
players<-c("Nadal R.","Djokovic N.","Berrettini M.","Sinner J.")
rank_plot(res_welo,players,line_width=1.5)
}
