% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/custom_logging.R
\name{custom_logging}
\alias{custom_logging}
\alias{log_read}
\alias{log_write}
\alias{log_delete}
\title{Helper function to log custom messages}
\usage{
log_read(file, log = Sys.getenv("WHIRL_LOG_MSG"))

log_write(file, log = Sys.getenv("WHIRL_LOG_MSG"))

log_delete(file, log = Sys.getenv("WHIRL_LOG_MSG"))
}
\arguments{
\item{file}{\code{\link[=character]{character()}} description of the file that was read, written or
deleted.}

\item{log}{\code{\link[=character]{character()}} path to the log file.}
}
\description{
Useful for e.g. read and write operations on databases etc.
that are not automatically captured.
}
\details{
The default environment variable \code{WHIRL_LOG_MSG} is set in the session used
to log scripts, and input is automatically captured in the resulting log.

If run outside of whirl, meaning when the above environment variable is
unset, the operations are streamed to \code{stdout()}. By default the console.
}
\examples{
# Stream logs to console since `WHIRL_LOG_MSG` is not set:
log_read("my/folder/input.txt")
log_write("my/folder/output.txt")
log_delete("my/folder/old_output.txt")
}
