% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/retrieve_valuelabel.R
\name{retrieve_valuelabel}
\alias{retrieve_valuelabel}
\title{Retrieves Value Labels from GENESIS Databases}
\usage{
retrieve_valuelabel(
  variablename,
  valuelabel = "*",
  genesis = NULL,
  language = "de",
  ...
)
}
\arguments{
\item{variablename}{name of the variable}

\item{valuelabel}{"*" (default) retrieves all value labels.}

\item{genesis}{to authenticate a user and set the database (see below).}

\item{language}{retrieve information in German "de" (default) or in English "en" if available.}

\item{...}{other arguments send to the httr::GET request.}
}
\value{
a \code{data.frame}.
}
\description{
\code{retrieve_valuelabel} retrieves value labels for variable
}
\details{
See the package description (\code{\link{wiesbaden}}) for details about setting the login and database.
}
\examples{

 \dontrun{
 # Value labels contain for the variable 'PART04' in the table with the 
 # federal election results on the county level. 
 # Assumes that user/password are stored via save_credentials()
 
 metadata <- retrieve_valuelabel(variablename="PART04", genesis=c(db="regio") )
 }




}
\seealso{
\code{\link{retrieve_datalist}} \code{\link{wiesbaden}}
}
