% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/createCsv.R
\name{to.csv}
\alias{to.csv}
\title{Create .csv file from a data frame}
\usage{
to.csv(df, df_name = NULL, path = ".", skip_prompt = FALSE)
}
\arguments{
\item{df}{Data frame to be exported to CSV format.}

\item{df_name}{Optional; a custom file name for the saved CSV file.
If not provided, the name of the data frame variable is used.
The function adds the ".csv" extension automatically.}

\item{path}{Character string specifying the directory path where the "tmp" folder
and CSV file should be created. Defaults to the current working directory.}

\item{skip_prompt}{Logical. If TRUE, skips the confirmation prompt. If FALSE (default),
will prompt for confirmation unless the user has previously chosen to remember their preference.}
}
\value{
Invisible TRUE if successful. The function writes a CSV file to the specified path
and prints a message indicating the file's location.
}
\description{
This function exports a given R data frame to a CSV file format.
The resulting file is saved in the "tmp" directory. If a filename
is not specified, the function uses the name of the data frame variable.
The ".csv" extension is appended automatically to the filename.
The function will prompt for confirmation before creating the file,
with an option to remember the user's preference for future calls.
}
\examples{
\dontrun{
# Create a sample data frame
sample_df <- data.frame(
  id = 1:3,
  name = c("Alice", "Bob", "Charlie")
)

# Basic usage with prompt
to.csv(sample_df)

# Custom filename
to.csv(sample_df, "participants_data")

# Skip the confirmation prompt
to.csv(sample_df, skip_prompt = TRUE)

# Save in a different directory
to.csv(sample_df, path = "path/to/project")
}

}
\author{
Joshua Kenney \href{mailto:joshua.kenney@yale.edu}{joshua.kenney@yale.edu}
}
