% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/functions_legendre.R
\name{.CalcLegendre}
\alias{.CalcLegendre}
\title{Compute Associated Legendre Functions Given Sequence of (degree, order) Indices}
\usage{
.CalcLegendre(mu)
}
\arguments{
\item{mu}{Function argument to \eqn{P_{n,m}(\mu)}{P_{n,m}(mu)}}
}
\description{
Procedure that computes the associated Legendre function, \eqn{P_{n,m}(\mu)}{P_{n,m}(mu)}, given a sequence of (degree, order) indices and function argument \eqn{\mu}{mu}. This is computed via a closed-form equation.
}
\details{
The underlying equation used is: \deqn{P(x, n, m)=(-1)^m * 2^n * (1-x^2)^(m/2) * sum(for m <= k <= n: k!/(k-m)! * x^(k-m) * choose(n, k) * choose((n+k-1)/2, n))}
}
