% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/functions_legendre.R
\name{.CalcPolynomialComponents}
\alias{.CalcPolynomialComponents}
\title{Calculate Polynomial Components for Associated Legendre Function}
\usage{
.CalcPolynomialComponents(mu)
}
\arguments{
\item{mu}{Function argument to \eqn{P_{n,m}(\mu)}{P_{n,m}(mu)}}
}
\description{
Function that computes the polynomial components of \code{mu} that are paired with the output of \code{.CalcLegendreComponents} to create the indiviudal components of the associated Legendre function, \eqn{P_{n,m}(\mu)}{P_{n,m}(mu)}.
}
\details{
The underlying equation used is: \deqn{P(x, n, m)=(-1)^m * 2^n * (1-x^2)^(m/2) * sum(for m <= k <= n: k!/(k-m)! * x^(k-m) * choose(n, k) * choose((n+k-1)/2, n))}
}
