% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/workpatterns_classify_bw.R
\name{workpatterns_classify_bw}
\alias{workpatterns_classify_bw}
\title{Classify working pattern week archetypes using a rule-based algorithm,
using the binary week-based ('bw') method.}
\usage{
workpatterns_classify_bw(
  data,
  hrvar = NULL,
  signals = c("email", "IM"),
  start_hour = "0900",
  end_hour = "1700",
  active_threshold = 0,
  return = "plot"
)
}
\arguments{
\item{data}{A data frame containing email by hours data.}

\item{hrvar}{A string specifying the HR attribute to cut the data by.
Defaults to NULL. This only affects the function when "table" is returned.}

\item{signals}{Character vector to specify which collaboration metrics to
use:
\itemize{
\item a combination of signals, such as \code{c("email", "IM")} (default)
\item \code{"email"} for emails only
\item \code{"IM"} for Teams messages only
\item \code{"unscheduled_calls"} for Unscheduled Calls only
\item \code{"meetings"} for Meetings only
}}

\item{start_hour}{A character vector specifying start hours,
e.g. "0900"}

\item{end_hour}{A character vector specifying finish hours,
e.g. "1700"}

\item{active_threshold}{A numeric value specifying the minimum number of
signals to be greater than in order to qualify as \emph{active}. Defaults to 0.}

\item{return}{Character vector to specify what to return.
Valid options include:
\itemize{
\item \code{"plot"}: returns a heatmap plot of signal distribution by hour
and archetypes (default)
\item \code{"data"}: returns the raw data with the classified
archetypes
\item \code{"table"}: returns a summary table of the archetypes
\item \code{"plot-area"}: returns an area plot of the percentages of archetypes
shown over time
}}
}
\value{
A different output is returned depending on the value passed to the \code{return}
argument:
\itemize{
\item \code{"plot"}: returns a heatmap plot of signal distribution by hour
and archetypes (default). A 'ggplot' object.
\item \code{"data"}: returns a data frame of the raw data with the classified
archetypes
\item \code{"table"}: returns a data frame of summary table of the archetypes
\item \code{"plot-area"}: returns an area plot of the percentages of archetypes
shown over time. A 'ggplot' object.
}
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#experimental}{\figure{lifecycle-experimental.svg}{options: alt='[Experimental]'}}}{\strong{[Experimental]}}

Apply a rule based algorithm to emails sent by hour of day, using the binary
week-based ('bw') method.
}
\seealso{
Other Working Patterns: 
\code{\link{flex_index}()},
\code{\link{identify_shifts_wp}()},
\code{\link{identify_shifts}()},
\code{\link{plot_flex_index}()},
\code{\link{workpatterns_area}()},
\code{\link{workpatterns_classify_pav}()},
\code{\link{workpatterns_classify}()},
\code{\link{workpatterns_hclust}()},
\code{\link{workpatterns_rank}()},
\code{\link{workpatterns_report}()}
}
\concept{Working Patterns}
