% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/network_leiden.R
\name{network_leiden}
\alias{network_leiden}
\title{Implement the Leiden community detection on a Person to Person network
query}
\usage{
network_leiden(
  data,
  hrvar = "Organization",
  bg_fill = "#000000",
  font_col = "#FFFFFF",
  algorithm = "mds",
  path = "network_p2p_leiden",
  node_alpha = 0.8,
  res = 0.5,
  seed = 1,
  desc_hrvar = c("Organization", "LevelDesignation", "FunctionType"),
  return = "plot-leiden",
  size_threshold = 5000
)
}
\arguments{
\item{data}{Data frame containing a person-to-person query.}

\item{hrvar}{String containing the label for the HR attribute.}

\item{bg_fill}{String to specify background fill colour.}

\item{font_col}{String to specify font and link colour.}

\item{algorithm}{String to specify the node placement algorithm to be used.
Defaults to \code{"mds"} for the deterministic multi-dimensional scaling of
nodes. See
\url{https://rdrr.io/cran/ggraph/man/layout_tbl_graph_igraph.html} for a full
list of options.}

\item{path}{File path for saving the PDF output. Defaults to a timestamped
path based on current parameters.}

\item{node_alpha}{A numeric value between 0 and 1 to specify the transparency
of the nodes. Defaults to 0.7.}

\item{res}{Resolution parameter to be passed to \code{leiden::leiden()}. Defaults
to 0.5.}

\item{seed}{Seed for the random number generator passed to either
\code{set.seed()} when the Louvain algorithm is used, or \code{leiden::leiden()} when
the Leiden algorithm is used, to ensure consistency. Only applicable when
\code{display} is set to \code{"louvain"} or \code{"leiden"}.}

\item{desc_hrvar}{Character vector of length 3 containing the HR attributes
to use when returning the \code{"describe"} output. See \code{network_describe()}.}

\item{return}{String specifying what output to return. Defaults to "plot-leiden". Valid
return options include:
\itemize{
\item \code{'plot-leiden'}: return a network plot coloured by leiden communities,
saving a PDF to path.
\item \code{'plot-hrvar'}: return a network plot coloured by HR attribute, saving a
PDF to path.
\item \code{'plot-sankey'}: return a sankey plot combining communities and HR
attribute.
\item \code{'table'}: return a vertex summary table with counts in communities and
HR attribute.
\item \code{'data'}: return a vertex data file that matches vertices with
communities and HR attributes.
\item \code{'describe'}: return a list of data frames which describe each of the
identified communities. The first data frame is a summary table of all the
communities.
\item \code{'network'}: return 'igraph' object.
}}

\item{size_threshold}{Numeric value representing the maximum number of edges
before \code{network_leiden()} switches to use a more efficient, but less
elegant plotting method (native igraph). Defaults to 5000. Set as \code{0} to
coerce to a fast plotting method every time, and \code{Inf} to always use the
default plotting method (with 'ggraph').}
}
\value{
See \code{return}.
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#experimental}{\figure{lifecycle-experimental.svg}{options: alt='[Experimental]'}}}{\strong{[Experimental]}}

Take a P2P network query and implement the Leiden community detection method.
To run this function, you will require all the pre-requisites of the
'leiden' package installed, which includes Python and 'reticulate'.
}
\section{Simulating and running Leiden Community Detection}{


Below is an example on how to simulate a network and run the function.

\if{html}{\out{<div class="sourceCode">}}\preformatted{# Simulate a small person-to-person dataset
p2p_data <- p2p_data_sim(size = 50)

# Return leiden, console, plot
p2p_data \%>\%
  network_leiden(path = NULL,
                 return = "plot")
```

}\if{html}{\out{</div>}}
}

\seealso{
Other Network: 
\code{\link{external_network_plot}()},
\code{\link{g2g_data}},
\code{\link{internal_network_plot}()},
\code{\link{network_describe}()},
\code{\link{network_g2g}()},
\code{\link{network_louvain}()},
\code{\link{network_p2p}()},
\code{\link{network_summary}()},
\code{\link{p2p_data_sim}()}
}
\concept{Network}
