% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/validation_report.R
\name{validation_report}
\alias{validation_report}
\title{Generate a Data Validation report in HTML}
\usage{
validation_report(
  data,
  meeting_data = NULL,
  hrvar = "Organization",
  path = "validation report",
  hrvar_threshold = 150,
  timestamp = TRUE
)
}
\arguments{
\item{data}{A Standard Person Query dataset in the form of a data frame.}

\item{meeting_data}{An optional Meeting Query dataset in the form of a data
frame.}

\item{hrvar}{HR Variable by which to split metrics, defaults to "Organization"
but accepts any character vector, e.g. "Organization"}

\item{path}{Pass the file path and the desired file name, \emph{excluding the file
extension}.}

\item{hrvar_threshold}{Numeric value determining the maximum number of unique
values to be allowed to qualify as a HR variable. This is passed directly
to the \code{threshold} argument within \code{hrvar_count_all()}.}

\item{timestamp}{Logical vector specifying whether to include a timestamp in
the file name. Defaults to \code{TRUE}.}
}
\value{
An HTML report with the same file name as specified in the arguments is
generated in the working directory. No outputs are directly returned by the
function.
}
\description{
The function generates an interactive HTML report using
Standard Person Query data as an input. The report contains checks on
Workplace Analytics query outputs to provide diagnostic information
for the Analyst prior to analysis.

An additional Standard Meeting Query can be provided to perform meeting
subject line related checks. This is optional and the validation report can
be run without it.
}
\details{
For your input to \code{data} or \code{meeting_data}, please use the function
\code{wpa::import_wpa()} to import your csv query files into R. This function will
standardize format and prepare the data as input for this report.

If you are passing a Ways of Working Assessment query instead of a Standard
Person query to the \code{data} argument, please also use \code{standardise_pq()} to
make the variable names consistent with a Standard Person Query.

Since \code{v1.6.2}, the variable \code{Call_hours} is no longer a pre-requisite to run
this report. A note is returned in-line instead of an error if the variable
is not available.
}
\section{Checking functions within \code{validation_report()}}{

\itemize{
\item \code{check_query()}
\item \code{flag_ch_ratio()}
\item \code{hrvar_count_all()}
\item \code{identify_privacythreshold()}
\item \code{identify_nkw()}
\item \code{identify_holidayweeks()}
\item \code{subject_validate()}
\item \code{identify_tenure()}
\item \code{flag_outlooktime()}
\item \code{identify_shifts()}
\item \code{track_HR_change()}
}

You can browse each individual function for details on calculations.
}

\section{Creating a report}{


Below is an example on how to run the report.

\if{html}{\out{<div class="sourceCode">}}\preformatted{validation_report(dv_data,
                  meeting_data = mt_data,
                  hrvar = "Organization")
}\if{html}{\out{</div>}}
}

\seealso{
Other Reports: 
\code{\link{IV_report}()},
\code{\link{capacity_report}()},
\code{\link{coaching_report}()},
\code{\link{collaboration_report}()},
\code{\link{connectivity_report}()},
\code{\link{generate_report}()},
\code{\link{meeting_tm_report}()},
\code{\link{read_preamble}()},
\code{\link{subject_validate_report}()},
\code{\link{workpatterns_report}()}

Other Data Validation: 
\code{\link{check_query}()},
\code{\link{extract_hr}()},
\code{\link{flag_ch_ratio}()},
\code{\link{flag_em_ratio}()},
\code{\link{flag_extreme}()},
\code{\link{flag_outlooktime}()},
\code{\link{hr_trend}()},
\code{\link{hrvar_count_all}()},
\code{\link{hrvar_count}()},
\code{\link{hrvar_trend}()},
\code{\link{identify_churn}()},
\code{\link{identify_holidayweeks}()},
\code{\link{identify_inactiveweeks}()},
\code{\link{identify_nkw}()},
\code{\link{identify_outlier}()},
\code{\link{identify_privacythreshold}()},
\code{\link{identify_query}()},
\code{\link{identify_shifts_wp}()},
\code{\link{identify_shifts}()},
\code{\link{identify_tenure}()},
\code{\link{remove_outliers}()},
\code{\link{standardise_pq}()},
\code{\link{subject_validate_report}()},
\code{\link{subject_validate}()},
\code{\link{track_HR_change}()}
}
\concept{Data Validation}
\concept{Reports}
