% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/anlz_smooth.R
\name{anlz_smooth}
\alias{anlz_smooth}
\title{Return summary statistics for smoothers of GAMs}
\usage{
anlz_smooth(mod)
}
\arguments{
\item{mod}{input model object as returned by \code{\link{anlz_gam}}}
}
\value{
a \code{data.frame} with summary statistics for smoothers in each GAM
}
\description{
Return summary statistics for smoothers of GAMs
}
\details{
Results show the individual effects of the modelled components of each model as the estimated degrees of freedom (\code{edf}), the reference degrees of freedom (\code{Ref.df}), the test statistic (\code{F}), and significance of the component (\code{p-value}).  The significance of the component is in part based on the difference between \code{edf} and \code{Ref.df}.
}
\examples{
library(dplyr)

# data to model
tomod <- rawdat \%>\%
  filter(station \%in\% 34) \%>\%
  filter(param \%in\% 'chl')
  
mod <- anlz_gam(tomod, trans = 'log10')
anlz_smooth(mod)
}
\concept{analyze}
