% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/makeMAList.R
\name{makeMAList}
\alias{makeMAList}
\title{make MA-List object}
\usage{
makeMAList(mat, MAfac, useF = c("R", "G"), isLog = TRUE,
  silent = FALSE, callFrom = NULL)
}
\arguments{
\item{mat}{main input matrix}

\item{MAfac}{(factor) factor orgnaizing columns of 'mat' (if \code{useF} contains the default 'R' and 'G', they should also be part of \code{MAfac})}

\item{useF}{(character) two specific factor-leves of \code{MAfac} that will be used/extracted}

\item{isLog}{(logical) tell if data is already log2 (will be considered when computing M and A values)}

\item{silent}{(logical) suppress messages}

\item{callFrom}{(character) allows easier tracking of message(s) produced}
}
\value{
limma-type "MAList" containing M and A values
}
\description{
\code{makeMAList} extracts sets of data-pairs (like R & G series) and makes MA objects as \code{MA-List object} (eg for ratio oriented analysis).
The grouping of columns as sets of replicate-measurements is done according to argumnet \code{'MAfac'}.
The output is fully compatible to functions of package \href{https://bioconductor.org/packages/release/bioc/html/limma.html}{limma} (Bioconductor).
}
\examples{
set.seed(2017); t4 <- matrix(round(runif(40,1,9),2),ncol=4,
  dimnames=list(letters[c(1:5,3:4,6:4)],c("AA1","BB1","AA2","BB2")))
makeMAList(t4,gl(2,2,labels=c("R","G")))
}
\seealso{
\code{MA.RG} in \code{\link[limma]{normalizeWithinArrays}}
}
