% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summarizeCols.R
\name{summarizeCols}
\alias{summarizeCols}
\title{Summarize columns (as median,mean,min,last or other methods)}
\usage{
summarizeCols(matr, meth = "median", silent = FALSE, callFrom = NULL)
}
\arguments{
\item{matr}{data.frame matrix of data to be summarized by comlumn (may do different method for text and numeric comlumns)}

\item{meth}{(character) summarization method (eg 'maxLast','minLast','maxLast','maxAbsLast','minLast','medianComplete' or 'meanComplete')}

\item{silent}{(logical) suppress messages}

\item{callFrom}{(character) allow easier tracking of message(s) produced}
}
\value{
vector with summary for each column
}
\description{
\code{summarizeCols} summarizes all columns of matrix (or data.frame).
In case of text-columns the sorted middle (~median) will be given, unless 'maxLast', 'minLast',
 'maxLast','maxAbsLast' or 'minLast' .. consider only last column of 'matr' : choose from all columns the line where (max of) last col is at min;
 'medianComplete' or 'meanComplete' consideres only lines/rows where no NA occur (NA have influence other columns !)
}
\examples{
t1 <- matrix(round(runif(30,1,9)),nc=3); rownames(t1) <- letters[c(1:5,3:4,6:4)]
summarizeCols(t1,me="median")
t(sapply(by(t1,rownames(t1), function(x) x), summarizeCols,me="maxLast"))
t3 <- data.frame(ref=rep(11:15,3),tx=letters[1:15],
  matrix(round(runif(30,-3,2),1),ncol=2),stringsAsFactors=FALSE)
by(t3,t3[,1],function(x) x)
t(sapply(by(t3,t3[,1],function(x) x), summarizeCols,me="maxAbsLast"))
}
\seealso{
\code{rowMeans} in \code{\link[base]{colSums}}
}
