% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rowSds.R
\name{rowSds}
\alias{rowSds}
\title{sd for each row (fast execution)}
\usage{
rowSds(dat)
}
\arguments{
\item{dat}{matrix (or data.frame) with numeric values (may contain NAs)}
}
\value{
numeric vector of sd values
}
\description{
\code{rowSds} is speed optimized sd (takes matrix or data.frame and treats each line as set of data for sd {equiv to apply(dat,1,sd)}.
NAs are ignored from data unless entire line NA). Speed improvements may be seen at more than 100 lines.
Note: NaN instances will be transformed to NA
}
\examples{
set.seed(2016); dat1 <- matrix(c(runif(200)+rep(1:10,20)),ncol=10)
rowSds(dat1)
}
\seealso{
\code{\link[stats]{sd}}
}
