% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fusePairs.R
\name{fusePairs}
\alias{fusePairs}
\title{Fuse pairs to generate cluster-names}
\usage{
fusePairs(
  datPair,
  refDatNames = NULL,
  inclRepLst = FALSE,
  maxFuse = NULL,
  debug = FALSE,
  silent = TRUE,
  callFrom = NULL
)
}
\arguments{
\item{datPair}{2-column matrix where each line represents 1 pair}

\item{refDatNames}{(NULL or character) allows placing selected pairs in context of larger data-set (names to match those of 'datPair')}

\item{inclRepLst}{(logical) if TRUE, return list with 'clu' (clu-numbers, default output) and 'refLst' (list of clustered elements, only n>1)}

\item{maxFuse}{(integer, default NULL) maximal number of groups/clusters}

\item{debug}{(logical) for bug-tracking: more/enhanced messages and intermediate objects written in global name-space}

\item{silent}{(logical) suppress messages}

\item{callFrom}{(character) allow easier tracking of message(s) produced}
}
\value{
vector with cluster-numbers
}
\description{
Fuse previously identified pairs to 'clusters', return vector with cluster-numbers.
}
\examples{
daPa <- matrix(c(1:5,8,2:6,9),ncol=2)
fusePairs(daPa,maxFuse=4)
}
