% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/firstOfRepLines.R
\name{firstOfRepLines}
\alias{firstOfRepLines}
\title{Reduce to first occurance of repeated lines}
\usage{
firstOfRepLines(mat, outTy = "ind", useCol = NULL, callFrom = NULL)
}
\arguments{
\item{mat}{initial matrix to treat}

\item{outTy}{for output type: 'ind'.. index to 1st occurance (non-red),'orig'..non-red lines of mat, 'conc'.. non-red concateneted values, 'num'.. index to which group/category the lines belong}

\item{useCol}{(integer) custom choice of which columns to paste/concatenate}

\item{callFrom}{(character) allows easier tracking of messages produced}
}
\value{
simplified/non-redundant vector/matrix (ie fewer lines for matrix), or respective index
}
\description{
This function concatenattes all columns of input-matrix and then searches like \code{unique} for unique elements, optionally the indexes of unique elements may get returned.
Note: This function reats input as character (thus won't understand \code{10==10.0} ).
Returns simplified/non-redundant vector/matrix (ie fewer lines), or respective index.
faster than  \code{\link{firstOfRepeated}}
}
\examples{
mat <- matrix(c("e","n","a","n","z","z","n","z","z","b", 
  "","n","c","n","","","n","","","z"),ncol=2)
firstOfRepLines(mat,out="conc")
}
\seealso{
\code{\link[base]{unique}}, \code{\link{nonAmbiguousNum}}, faster than \code{\link{firstOfRepeated}} which gives more detail in output (lines/elements/indexes of omitted)
}
