% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/readFasta2.R
\name{readFasta2}
\alias{readFasta2}
\title{Read file of protein sequences in fasta format
  
Read fasta formatted file (from Uniprot) to extract (protein) sequences and name.
If \code{tableOut=TRUE} output may be organized as matrix for separating meta-annotationExtract, see also \href{https://www.uniprot.org/help/fasta-headers}{FASTA-headers}.}
\usage{
readFasta2(filename, delim = "|", databaseSign = c("sp", "tr",
  "generic", "gi"), tableOut = FALSE, UniprSep = c("OS=", "OX=", "GN=",
  "PE=", "SV="), cleanCols = TRUE, silent = FALSE, callFrom = NULL,
  debug = FALSE)
}
\arguments{
\item{filename}{(character) names fasta-file to be read}

\item{delim}{(character) delimeter at header-line}

\item{databaseSign}{(character) characters at beginning right afetr the '>' (typically specifying the data-base-origin), they will be excluded from the sequance-header}

\item{tableOut}{(logical) toggle to return named character-vector or matrix with enhaced parsing of fasta-header. The resulting matrix will contain the comumns 'database','uniqueIdentifier','entryName','proteinName','sequence' and further columns depending on argument \code{UniprSep}}

\item{UniprSep}{(character) separators for further separating entry-fields if \code{tableOut=TRUE}, see also \href{https://www.uniprot.org/help/fasta-headers}{FASTA-headers}}

\item{cleanCols}{(logical) remove columns with all entries NA, if \code{tableOut=TRUE}}

\item{silent}{(logical) suppress messages}

\item{callFrom}{(character) allows easier tracking of message(s) produced}

\item{debug}{(logical) supplemental messages for debugging}
}
\value{
return (based on 'tableOut') simple character vector (of sequence) with Uniprot ID as name or matrix with columns: 'database','uniqueIdentifier','entryName','proteinName','sequence' and further columns depending on argument \code{UniprSep}
}
\description{
Read file of protein sequences in fasta format
  
Read fasta formatted file (from Uniprot) to extract (protein) sequences and name.
If \code{tableOut=TRUE} output may be organized as matrix for separating meta-annotationExtract, see also \href{https://www.uniprot.org/help/fasta-headers}{FASTA-headers}.
}
\examples{
path1 <- system.file('extdata',package='wrProteo')
fiNa <-  "conta1.fasta"
fasta1 <- readFasta2(file.path(path1,fiNa))
## now let's read and further separate annotation-fields
fasta2 <- readFasta2(file.path(path1,fiNa),tableOut=TRUE)
str(fasta1)
}
\seealso{
\code{\link[base]{scan}} or \code{\link[seqinr]{read.fasta}}
}
