% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/wvar.R
\name{plot.wvar}
\alias{plot.wvar}
\title{Plot Wavelet Variances}
\usage{
\method{plot}{wvar}(x, units = NULL, xlab = NULL, ylab = NULL,
  main = NULL, col_wv = NULL, col_ci = NULL, nb_ticks_x = NULL,
  nb_ticks_y = NULL, legend_position = NULL, ci_wv = NULL,
  point_cex = NULL, point_pch = NULL, ...)
}
\arguments{
\item{x}{A \code{wvar} object.}

\item{units}{A \code{string} that specifies the units of time plotted on the x axis.}

\item{xlab}{A \code{string} that gives a title for the x axis.}

\item{ylab}{A \code{string} that gives a title for the y axis.}

\item{main}{A \code{string} that gives an overall title for the plot.}

\item{col_wv}{A \code{string} that specifies the color of the wavelet variance line.}

\item{col_ci}{A \code{string} that specifies the color of the confidence interval polygon.}

\item{nb_ticks_x}{An \code{integer} that specifies the maximum number of ticks for the x-axis.}

\item{nb_ticks_y}{An \code{integer} that specifies the maximum number of ticks for the y-axis.}

\item{legend_position}{A \code{string} that specifies the position of the legend (use \code{legend_position = NA} to remove legend).}

\item{ci_wv}{A \code{boolean} that determines whether a confidence interval polygon will be drawn.}

\item{point_cex}{A \code{double} that specifies the size of each symbol to be plotted.}

\item{point_pch}{A \code{double} that specifies the symbol type to be plotted.}

\item{...}{Additional arguments affecting the plot.}
}
\value{
Plot of wavelet variance and confidence interval for each scale.
}
\description{
Displays a plot of wavelet variance accounting for CI values and supplied efficiency.
}
\examples{
set.seed(999)
n = 10^4
Xt = rnorm(n)
wv = wvar(Xt)
plot(wv)
plot(wv, main = "Simulated white noise", xlab = "Scales")
plot(wv, units = "sec", legend_position = "topright")
plot(wv, col_wv = "darkred", col_ci = "pink")
}
\author{
Stephane Guerrier, Nathanael Claussen, and Justin Lee
}
\keyword{internal}
