% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/xegaPermMutate.R
\name{xegaPermMutateGeneOrderBased}
\alias{xegaPermMutateGeneOrderBased}
\title{Mutate a gene (generalized order based mutation).}
\usage{
xegaPermMutateGeneOrderBased(gene, lF)
}
\arguments{
\item{gene}{A Permutation.}

\item{lF}{Local configuration of the genetic algorithm.}
}
\value{
A Permutation.
}
\description{
\code{xegaPermMutateGene} mutates a permutation.
              The per position mutation rate is given by 
              \code{lF$BitMutationRate1()}.
}
\details{
This operator is an implementation of a generalized 
         order based mutation operator (Syswerda, 1991).

         \enumerate{
         \item The indices of a random subschedule are extracted.
         \item The subschedule is extracted, permuted, and reinserted.
         }
}
\examples{
gene1<-xegaPermInitGene(lFxegaPermGene)
xegaPermDecodeGene(gene1, lFxegaPermGene)
gene<-xegaPermMutateGeneOrderBased(gene1, lFxegaPermGene)
xegaPermDecodeGene(gene, lFxegaPermGene)
}
\references{
Syswerda, G. (1991): 
            Schedule Optimization Using Genetic Algorithms.
            In: Davis, L. (Ed.): 
            Handbook of Genetic Algorithms, Chapter 21, pp. 332-349.
            Van Nostrand Reinhold, New York.
            (ISBN:0-442-00173-8)
}
\seealso{
Other Mutation: 
\code{\link{xegaPermMutateGene2Opt}()},
\code{\link{xegaPermMutateGeneBestGreedy}()},
\code{\link{xegaPermMutateGeneGreedy}()},
\code{\link{xegaPermMutateGenekInversion}()},
\code{\link{xegaPermMutateGenekOptLK}()},
\code{\link{xegaPermMutateMix}()}
}
\concept{Mutation}
