% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Data.R, R/SData.R
\name{data_extract_or_assign}
\alias{data_extract_or_assign}
\alias{Data}
\alias{Data<-}
\alias{SData}
\alias{SData<-}
\title{Extract or assign data from an xpose.data object.}
\usage{
Data(object, inclZeroWRES = FALSE, onlyfirst = FALSE, subset = NULL)

Data(object, quiet = TRUE, keep.structure = F) <- value

SData(object, inclZeroWRES = FALSE, onlyfirst = FALSE, subset = NULL,
  samp = NULL)

SData(object) <- value
}
\arguments{
\item{object}{An "xpose.data" object}

\item{inclZeroWRES}{Logical value indicating whether rows with WRES==0
should be included in the extracted data.}

\item{onlyfirst}{Logical value indicating whether only the first line per
individual should be included in the extracted data.}

\item{subset}{Expression with which the extracted data should be subset (see
\code{\link{xsubset}})}

\item{quiet}{\code{TRUE or FALSE} if \code{FALSE} then some more information
is printed out when adding data to an Xpose object.}

\item{keep.structure}{\code{TRUE or FALSE} if\code{FALSE} then values are
converted to continuous or categorical according to the rules set up by
xpose using object@Prefs@Cat.levels, object@Prefs@DV.cat.levels and the
values in the "catab" file.}

\item{value}{An R data.frame.}

\item{samp}{An integer between 1 and object@Nsim
(see\code{\link{xpose.data-class}}) specifying which of the simulated data
sets to extract from SData.}
}
\value{
Returns a data.frame from the Data or SData slots, excluding rows as
indicated by the arguments.
}
\description{
Extracts or assigns the data from the Data or SData slots in an "xpose.data" object.
}
\details{
When using Data to assign a data.frame to the Data slot in the "xpose.data"
object a number of things happen:

Each column in the data.frame is checked and set to factor if the number of
unique values are less than the value of Cat.levels (see
\code{\link{xpose.prefs-class}}).

It is checked which of the predefined xpose data variables that exists in
the data.frame. The variable definitions that does not exist are set to NULL.

The column identified by the \code{dv} xpose variable definition, is checked
and set to factor if the number of unique values are less than or equal to
the DV.Cat.levels (see \code{\link{xpose.prefs-class}}).

Finally, each column name in the data.frame is checked for a label (see
\code{\link{xpose.prefs-class}}). If it is non-existent, the label is set to
the column name.

When SData is used to assign a data.frame to the SData slot it is first
checked that the number of rows in the SData data.frame is an even multiple
of the number of rown in Data. Next, each column in the SData data.frame is
assigned the same class as the corresponding column in the Data data.frame
(it is required that the columns are the same in Data and SData). Finally,
an extra column, "iter", is added to SData, which indicates the iteration
number that each row belongs to. At the same time, the Nsim slot of the
"xpose.data" object is set to the number of iterations (see
\code{\link{nsim}}).
}
\section{Functions}{
\itemize{
\item \code{Data}: Extract data

\item \code{Data<-}: assign data

\item \code{SData}: extract simulated data

\item \code{SData<-}: assign simulated data
}}

\examples{

xpdb <- simpraz.xpdb

## Extract data
my.dataframe <- Data(xpdb)

## Assign data
Data(xpdb) <- my.dataframe

## Extract simulated data
my.simulated.dataframe <- SData(xpdb)

## Assign simulated data
SData(xpdb) <- my.simulated.dataframe

}
\seealso{
\code{\link{xpose.data-class}},\code{\link{xpose.prefs-class}}

Other data functions: \code{\link{add_transformed_columns}},
  \code{\link{change_graphical_parameters}},
  \code{\link{change_misc_parameters}},
  \code{\link{compute.cwres}}, \code{\link{data.checkout}},
  \code{\link{db.names}}, \code{\link{export.graph.par}},
  \code{\link{export.variable.definitions}},
  \code{\link{import.graph.par}},
  \code{\link{import.variable.definitions}},
  \code{\link{make.sb.data}}, \code{\link{nsim}},
  \code{\link{par_cov_summary}},
  \code{\link{read.TTE.sim.data}},
  \code{\link{read.nm.tables}},
  \code{\link{read_NM_output}},
  \code{\link{read_nm_table}},
  \code{\link{simprazExample}},
  \code{\link{tabulate.parameters}}, \code{\link{xlabel}},
  \code{\link{xpose.data}}, \code{\link{xpose.print}},
  \code{\link{xpose4-package}}, \code{\link{xsubset}}
}
\author{
Niclas Jonsson
}
\keyword{methods}
