% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ind.plots.cwres.hist.R, R/ind.plots.wres.hist.R
\name{ind.plots.cwres.hist}
\alias{ind.plots.cwres.hist}
\alias{ind.plots.wres.hist}
\title{Histograms of weighted residuals for each individual in an Xpose data
object, for Xpose 4}
\usage{
ind.plots.cwres.hist(object, wres = "cwres", ...)

ind.plots.wres.hist(
  object,
  main = "Default",
  wres = "wres",
  ylb = NULL,
  layout = c(4, 4),
  inclZeroWRES = FALSE,
  subset = xsubset(object),
  scales = list(cex = 0.7, tck = 0.5),
  aspect = "fill",
  force.by.factor = TRUE,
  ids = F,
  as.table = TRUE,
  hicol = object@Prefs@Graph.prefs$hicol,
  hilty = object@Prefs@Graph.prefs$hilty,
  hilwd = object@Prefs@Graph.prefs$hilwd,
  hidcol = object@Prefs@Graph.prefs$hidcol,
  hidlty = object@Prefs@Graph.prefs$hidlty,
  hidlwd = object@Prefs@Graph.prefs$hidlwd,
  hiborder = object@Prefs@Graph.prefs$hiborder,
  prompt = FALSE,
  mirror = NULL,
  main.cex = 0.9,
  max.plots.per.page = 1,
  ...
)
}
\arguments{
\item{object}{An xpose.data object.}

\item{wres}{Which weighted residual should we plot? Defaults to the WRES.}

\item{\dots}{Other arguments passed to \code{\link{xpose.plot.histogram}}.}

\item{main}{The title of the plot.  If \code{"Default"} then a default title
is plotted. Otherwise the value should be a string like \code{"my title"} or
\code{NULL} for no plot title.}

\item{ylb}{A string giving the label for the y-axis. \code{NULL} if none.}

\item{layout}{A list giving the layout of the graphs on the plot, in columns
and rows. The default is 4x4.}

\item{inclZeroWRES}{Logical value indicating whether rows with WRES=0 is
included in the plot. The default is FALSE.}

\item{subset}{A string giving the subset expression to be applied to the
data before plotting. See \code{\link{xsubset}}.}

\item{scales}{see \code{\link{xpose.plot.histogram}}}

\item{aspect}{see \code{\link{xpose.plot.histogram}}}

\item{force.by.factor}{see \code{\link{xpose.plot.histogram}}}

\item{ids}{see \code{\link{xpose.plot.histogram}}}

\item{as.table}{see \code{\link{xpose.plot.histogram}}}

\item{hicol}{the fill colour of the histogram - an integer or string.  The
default is blue (see \code{\link[lattice]{histogram}}).}

\item{hilty}{the border line type of the histogram - an integer.  The
default is 1 (see \code{\link[lattice]{histogram}}).}

\item{hilwd}{the border line width of the histogram - an integer.  The
default is 1 (see \code{\link[lattice]{histogram}}).}

\item{hidcol}{the fill colour of the density line - an integer or string.
The default is black (see \code{\link[lattice]{histogram}}).}

\item{hidlty}{the border line type of the density line - an integer.  The
default is 1 (see \code{\link[lattice]{histogram}}).}

\item{hidlwd}{the border line width of the density line - an integer.  The
default is 1 (see \code{\link[lattice]{histogram}}).}

\item{hiborder}{the border colour of the histogram - an integer or string.
The default is black (see \code{\link[lattice]{histogram}}).}

\item{prompt}{Specifies whether or not the user should be prompted to press
RETURN between plot pages. Default is FALSE.}

\item{mirror}{Mirror plots are not yet implemented in this function and this
argument must contain a value of \code{NULL}}

\item{main.cex}{The size of the title.}

\item{max.plots.per.page}{Maximum number of plots per page}
}
\value{
Returns a compound plot comprising histograms of weighted residual
conditioned on individual.
}
\description{
This is a compound plot consisting of histograms of the distribution of
weighted residuals (any weighted residual available from NONMEM) for every
individual in the dataset.  It is a wrapper encapsulating arguments to the
\code{\link{xpose.plot.histogram}} function.
}
\details{
Matrices of histograms of weighted residuals in each included individual are
displayed. \code{ind.plots.cwres.hist} is just a wrapper for
\code{ind.plots.wres.hist(object,wres="cwres").}
}
\section{Functions}{
\itemize{
\item \code{ind.plots.cwres.hist}: Histograms of conditional 
weighted residuals for each individual
}}

\examples{
## Here we load the example xpose database 
xpdb <- simpraz.xpdb

## A plot of the first 16 individuals
ind.plots.cwres.hist(xpdb, subset="ID<18")

}
\seealso{
\code{\link{xpose.plot.histogram}},
\code{\link{xpose.panel.histogram}}, \code{\link[lattice]{histogram}},
\code{\link{xpose.prefs-class}}, \code{\link{xpose.data-class}}

Other specific functions: 
\code{\link{absval.cwres.vs.cov.bw}()},
\code{\link{absval.cwres.vs.pred.by.cov}()},
\code{\link{absval.cwres.vs.pred}()},
\code{\link{absval.iwres.cwres.vs.ipred.pred}()},
\code{\link{absval.iwres.vs.cov.bw}()},
\code{\link{absval.iwres.vs.idv}()},
\code{\link{absval.iwres.vs.ipred.by.cov}()},
\code{\link{absval.iwres.vs.ipred}()},
\code{\link{absval.iwres.vs.pred}()},
\code{\link{absval.wres.vs.cov.bw}()},
\code{\link{absval.wres.vs.idv}()},
\code{\link{absval.wres.vs.pred.by.cov}()},
\code{\link{absval.wres.vs.pred}()},
\code{\link{absval_delta_vs_cov_model_comp}},
\code{\link{addit.gof}()},
\code{\link{autocorr.cwres}()},
\code{\link{autocorr.iwres}()},
\code{\link{autocorr.wres}()},
\code{\link{basic.gof}()},
\code{\link{basic.model.comp}()},
\code{\link{cat.dv.vs.idv.sb}()},
\code{\link{cat.pc}()},
\code{\link{cov.splom}()},
\code{\link{cwres.dist.hist}()},
\code{\link{cwres.dist.qq}()},
\code{\link{cwres.vs.cov}()},
\code{\link{cwres.vs.idv.bw}()},
\code{\link{cwres.vs.idv}()},
\code{\link{cwres.vs.pred.bw}()},
\code{\link{cwres.vs.pred}()},
\code{\link{cwres.wres.vs.idv}()},
\code{\link{cwres.wres.vs.pred}()},
\code{\link{dOFV.vs.cov}()},
\code{\link{dOFV.vs.id}()},
\code{\link{dOFV1.vs.dOFV2}()},
\code{\link{data.checkout}()},
\code{\link{dv.preds.vs.idv}()},
\code{\link{dv.vs.idv}()},
\code{\link{dv.vs.ipred.by.cov}()},
\code{\link{dv.vs.ipred.by.idv}()},
\code{\link{dv.vs.ipred}()},
\code{\link{dv.vs.pred.by.cov}()},
\code{\link{dv.vs.pred.by.idv}()},
\code{\link{dv.vs.pred.ipred}()},
\code{\link{dv.vs.pred}()},
\code{\link{gof}()},
\code{\link{ind.plots.cwres.qq}()},
\code{\link{ind.plots}()},
\code{\link{ipred.vs.idv}()},
\code{\link{iwres.dist.hist}()},
\code{\link{iwres.dist.qq}()},
\code{\link{iwres.vs.idv}()},
\code{\link{kaplan.plot}()},
\code{\link{par_cov_hist}},
\code{\link{par_cov_qq}},
\code{\link{parm.vs.cov}()},
\code{\link{parm.vs.parm}()},
\code{\link{pred.vs.idv}()},
\code{\link{ranpar.vs.cov}()},
\code{\link{runsum}()},
\code{\link{wres.dist.hist}()},
\code{\link{wres.dist.qq}()},
\code{\link{wres.vs.idv.bw}()},
\code{\link{wres.vs.idv}()},
\code{\link{wres.vs.pred.bw}()},
\code{\link{wres.vs.pred}()},
\code{\link{xpose.VPC.both}()},
\code{\link{xpose.VPC.categorical}()},
\code{\link{xpose.VPC}()},
\code{\link{xpose4-package}}
}
\author{
E. Niclas Jonsson, Mats Karlsson, Justin Wilkins & Andrew Hooker
}
\concept{specific functions}
