% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/xtractogon.R
\name{xtractogon}
\alias{xtractogon}
\title{Extract environmental data in a polygon using ERDDAP.}
\usage{
xtractogon(xpos, ypos, tpos, dtype, verbose = FALSE)
}
\arguments{
\item{xpos}{- array giving longitudes (in decimal
degrees East, either 0-360 or -180 to 180) of polygon}

\item{ypos}{-  array giving latitudes (in decimal
degrees N; -90 to 90)of polygon}

\item{tpos}{- 2-array of minimum and maximum times as 'YYYY-MM-DD'}

\item{dtype}{- number or string identfying the ERDDAP parameter to extract}

\item{verbose}{- logical for verbose download out, default FALSE}
}
\value{
structure with data and dimensions
\itemize{
  \item extract$data - the masked data array dimensioned (lon,lat,time)
  \item extract$varname - the name of the parameter extracted
  \item extract$datasetname - ERDDAP dataset name
  \item extract$longitude - the longitudes on some scale as request
  \item extract$latitude - the latitudes always going south to north
  \item extract$time - the times of the extracts
  }
}
\description{
\code{xtractogon} uses the ERD ERDDAP data web service to extact
environmental data inside a polygon defined by vectors of
latitudes and longitudes
}
\section{Details}{

 xtractogon extracts the data from the smallest bounding box that contains
 the polygon, and then uses the function "point.in.polygon" from the "sp"
 package to mask out the areas outside of the polygon.
}
\examples{
tpos <- c("2014-09-01", "2014-10-01")
xpos <- mbnms$Longitude
ypos <- mbnms$Latitude
sanctchl <- xtractogon(xpos, ypos, tpos, 'erdVH2chlamday')
}

