% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lag.xts.R
\name{lag.xts}
\alias{lag.xts}
\alias{diff.xts}
\title{Lags and Differences of xts Objects}
\usage{
\method{lag}{xts}(x, k = 1, na.pad = TRUE, ...)

\method{diff}{xts}(
  x,
  lag = 1,
  differences = 1,
  arithmetic = TRUE,
  log = FALSE,
  na.pad = TRUE,
  ...
)
}
\arguments{
\item{x}{An xts object.}

\item{k}{Number of periods to shift.}

\item{na.pad}{Should \code{NA} be added so the result has the same number of
observations as \code{x}?}

\item{\dots}{Additional arguments.}

\item{lag}{Period to difference over.}

\item{differences}{Order of differencing.}

\item{arithmetic}{Should arithmetic or geometric differencing be used?}

\item{log}{Should (geometric) log differences be returned?}
}
\value{
An xts object with the desired lag and/or differencing.
}
\description{
Methods for computing lags and differences on xts objects. This provides
similar functionality as the \pkg{zoo} counterparts, but with some different
defaults.
}
\details{
The primary motivation for these methods was to take advantage of a faster
C-level implementation. Another motivation was to make \code{lag()} behave using
standard sign for \code{k}. Both \code{\link[=lag.zoo]{lag.zoo()}} and \code{\link[=lag.default]{lag.default()}} require a
\emph{negative} value for \code{k} in order to shift a series backward. So \code{k = 1},
shifts the series \emph{forward} one observation. This is especially confusing
because \code{k = 1} is the default for those functions. When \code{x} is an xts
object, \code{lag(x, 1)} returns an object where the value at time 't' is the
value at time 't-1' in the original object.

Another difference is that \code{na.pad = TRUE} by default, to better reflect the
transformation visually and for functions the require positional alignment
of data.

Set \code{options(xts.compat.zoo.lag = TRUE)} to use make \code{lag.xts()} consistent
with \code{lag.zoo()} by reversing the sign of \code{k} and setting \code{na.pad = FALSE}.
}
\examples{

x <- xts(1:10, Sys.Date()+1:10)
lag(x)    # currently using xts-style positive k 

lag(x, k=2)

lag(x, k=-1, na.pad=FALSE) # matches lag.zoo(x, k=1)

diff(x)
diff(x, lag=1)
diff(x, diff=2)
diff(diff(x))

}
\references{
\url{https://en.wikipedia.org/wiki/Lag}
}
\author{
Jeffrey A. Ryan
}
\keyword{chron}
\keyword{manip}
