% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/functions.R
\name{xyloplot.list}
\alias{xyloplot.list}
\title{Function for creating multiple xyloplots sharing a y-axis from lists of numeric vectors}
\usage{
\method{xyloplot}{list}(x, discrete = !is.numeric(unlist(x, use.names =
  FALSE)), ylim = if (discrete) c(0.5, length(levels(factor(unlist(x,
  use.names = FALSE)))) + 0.5) else range(unlist(x, use.names = FALSE)),
  breaks = if (discrete) seq(from = 0.5, by = 1, length.out =
  length(levels(factor(unlist(x, use.names = FALSE)))) + 1) else 30,
  space = 0.1, ylab = "Value", xlab = "Frequency density", ...)
}
\arguments{
\item{x}{List of numeric vectors of values.}

\item{discrete}{Logical value indicating whether to treat values as discrete (suitable for character vectors and factors) or continuous (suitable for numeric vectors).}

\item{ylim}{Limits of hte y-axis.}

\item{breaks}{A single positive integer value giving the number of histogram classes to evenly split the values in \code{x} into, or a numeric vector explicitly giving the boundaries of the histogram classes.}

\item{space}{The proportion of the total distance on the x-axis allocated to each 'xylophone' which should be left blank.}

\item{ylab}{Label for y-axis.}

\item{xlab}{Label for x-axis.}

\item{...}{Other arguments to be passed to \code{\link{plot}}.}
}
\description{
Function for creating multiple xyloplots sharing a y-axis from lists of numeric vectors
}

