% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/yamlet.R
\name{decorate.list}
\alias{decorate.list}
\title{Decorate List}
\usage{
\method{decorate}{list}(
  x,
  meta = NULL,
  ext = getOption("yamlet_extension", ".yaml"),
  overwrite = getOption("yamlet_overwrite", FALSE),
  ...
)
}
\arguments{
\item{x}{object inheriting from \code{list}}

\item{meta}{file path for corresponding yaml metadata, or a yamlet; an attempt will be made to guess the file path if x has a 'source' attribute (as for \code{\link[csv]{as.csv}})}

\item{ext}{file extension for metadata file, if relevant}

\item{overwrite}{whether to overwrite attributes that are already present (else give warning)}

\item{...}{passed to \code{\link{as_yamlet.character}} (by method dispatch)}
}
\value{
like x but with 'decorated' as first class element
}
\description{
Decorates a list-like object. Takes metadata
in yamlet format and loads it onto corresponding
list elements as attributes.
}
\examples{
example(decorate.data.frame)

}
\seealso{
Other decorate: 
\code{\link{decorate.character}()},
\code{\link{decorate.data.frame}()},
\code{\link{decorate}()},
\code{\link{decorations.data.frame}()},
\code{\link{decorations}()}
}
\concept{decorate}
\keyword{internal}
