% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/yamlet.R
\name{decorate.character}
\alias{decorate.character}
\title{Decorate Character}
\usage{
\method{decorate}{character}(x, meta = NULL,
  read = getOption("yamlet_import", as.csv),
  ext = getOption("yamlet_extension", ".yaml"), ...)
}
\arguments{
\item{x}{file path for table data}

\item{meta}{file path for corresponding yamlet metadata, or a yamlet object}

\item{read}{function or function name for reading x}

\item{ext}{file extension for metadata file, if relevant}

\item{...}{passed to read (if accepted) and to \code{\link{as_yamlet.character}}}
}
\value{
class 'decorated' 'data.frame'
}
\description{
Treats \code{x} as a file path. By default,
metadata is sought from a file with the same
base but the 'yaml' extension.
}
\examples{
file <- system.file(package = 'yamlet', 'extdata','quinidine.csv')
meta <- system.file(package = 'yamlet', 'extdata','quinidine.yaml')
identical(
  decorate(file),
  decorate(file, meta = meta)
)
identical(
  decorate(file, meta = as_yamlet(meta)),
  decorate(file, meta = meta)
)
a <- decorate(file)
b <- resolve(decorate(file))
c <- resolve(decorate(
  file,
  read = read.table,
  quote = "",
  as.is = FALSE,
  sep = ',',
  header = TRUE,
  na.strings = c('', '\\\\s', '.','NA'),
  strip.white = TRUE,
  check.names = FALSE
))
d <- decorate(
  file,
  read = read.table,
  quote = "",
  as.is = FALSE,
  sep = ',',
  header = TRUE,
  na.strings = c('', '\\\\s', '.','NA'),
  strip.white = TRUE,
  check.names = FALSE
)

# Importantly, b and c are identical with respect to factors
cbind(
  `as.is/!resolve`   = sapply(a, class), # no factors
  `as.is/resolve`    = sapply(b, class), # factors made during decoration
  `!as.is/resolve`   = sapply(c, class), # factors made twice!
  `!as.is/!resolve`  = sapply(d, class)  # factors made during read
)
str(a$Smoke)
str(b$Smoke)
str(c$Smoke)
str(d$Smoke)
levels(c$Creatinine)
levels(d$Creatinine) # level detail retained as 'guide'
}
\seealso{
Other decorate: \code{\link{decorate.data.frame}},
  \code{\link{decorate.list}}, \code{\link{decorate}},
  \code{\link{decorations.data.frame}},
  \code{\link{decorations}}

Other interface: \code{\link{as_classified.factor}},
  \code{\link{conditionalize.data.frame}},
  \code{\link{decorate.data.frame}},
  \code{\link{ggplot.decorated}},
  \code{\link{ggready.data.frame}},
  \code{\link{io_csv.character}},
  \code{\link{io_csv.data.frame}},
  \code{\link{io_table.character}},
  \code{\link{io_table.data.frame}},
  \code{\link{io_yamlet.character}},
  \code{\link{io_yamlet.data.frame}},
  \code{\link{is_parseable.default}},
  \code{\link{read_yamlet}},
  \code{\link{resolve.data.frame}},
  \code{\link{write_yamlet}}
}
\concept{decorate}
\concept{interface}
