% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/append_units.R
\name{append_units.default}
\alias{append_units.default}
\title{Append Units By Default}
\usage{
\method{append_units}{default}(x, open = getOption("append_units_open",
  " ("), close = getOption("append_units_close", ")"),
  style = getOption("append_units_style", "plain"), ...)
}
\arguments{
\item{x}{object}

\item{open}{character to precede units}

\item{close}{character to follow units}

\item{style}{one of 'plain', 'latex', or 'plotmath'}

\item{...}{passed to \code{\link{as_latex}}, \code{\link{as_plotmath}}}
}
\value{
same class as x with named character label of length four; of sub-class 'latex' or 'plotmath' depending on \code{style}
}
\description{
Units attribute is wrapped in \code{open} and
\code{close}, and appended to label.
If style is 'latex' or 'plotmath',
all elements are treated as spork
(\code{\link{as_spork}}) and coerced
to canonical form before concatenation.
}
\examples{
library(units)
library(magrittr)
x <- 1:10
attr(x, 'label') <- 'acceleration'
units(x) <- 'm/s^2'
y <- as_units('kg')
x \%>\% attr('label')
x \%>\% append_units \%>\% attr('label')
y \%>\% attr('label')
y \%>\% append_units \%>\% attr('label')
x \%>\% append_units(style = 'plain')
x \%>\% append_units(style = 'plotmath')
x \%>\% append_units(style = 'latex')


}
\seealso{
Other labels: \code{\link{alias.data.frame}},
  \code{\link{append_units.data.frame}},
  \code{\link{append_units}}, \code{\link{sub_units}}
}
\concept{labels}
\keyword{internal}
